/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.tables.block.ITabbedBlock;

public class StationTabPacket
implements IThreadsafePacket {
    private final BlockPos pos;

    public StationTabPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        ServerPlayer sender = context.getSender();
        if (sender != null) {
            Level world;
            ItemStack heldStack = sender.f_36096_.m_142621_();
            if (!heldStack.m_41619_()) {
                sender.f_36096_.m_142503_(ItemStack.f_41583_);
            }
            if (!(world = sender.m_20193_()).m_46805_(this.pos)) {
                return;
            }
            BlockState state = world.m_8055_(this.pos);
            if (state.m_60734_() instanceof ITabbedBlock) {
                ((ITabbedBlock)state.m_60734_()).openGui((Player)sender, sender.m_20193_(), this.pos);
            } else {
                MenuProvider provider = state.m_60750_(sender.m_20193_(), this.pos);
                if (provider != null) {
                    NetworkHooks.openScreen((ServerPlayer)sender, (MenuProvider)provider, (BlockPos)this.pos);
                }
            }
            if (!heldStack.m_41619_()) {
                sender.f_36096_.m_142503_(heldStack);
                TinkerNetwork.getInstance().sendVanillaPacket((Entity)sender, (Packet<?>)new ClientboundContainerSetSlotPacket(-1, -1, -1, heldStack));
            }
        }
    }

    public StationTabPacket(BlockPos pos) {
        this.pos = pos;
    }
}

