/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.inventory.EmptyItemHandler;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;

public class SolidFuelModule
extends FuelModule {
    private final NonNullConsumer<LazyOptional<IItemHandler>> itemListener = new WeakConsumerWrapper((Object)this, SolidFuelModule::resetHandler);
    private final BlockPos fuelPos;
    @Nullable
    private LazyOptional<IItemHandler> itemHandler;

    public SolidFuelModule(MantleBlockEntity parent, BlockPos fuelPos) {
        super(parent);
        this.fuelPos = fuelPos;
    }

    @Override
    protected void resetHandler(@Nullable LazyOptional<?> source) {
        if (source == null || source == this.itemHandler || source == this.fluidHandler) {
            if (Util.isForge()) {
                if (this.itemHandler != null && this.itemHandler != source) {
                    this.itemHandler.removeListener(this.itemListener);
                }
                if (this.fluidHandler != null && this.fluidHandler != source) {
                    this.fluidHandler.removeListener(this.fluidListener);
                }
            }
            this.itemHandler = null;
            this.fluidHandler = null;
        }
    }

    private int trySolidFuel(IItemHandler handler, boolean consume) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            int time = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)((RecipeType)TinkerRecipeTypes.FUEL.get())) / 4;
            if (time <= 0) continue;
            MeltingFuel solid = MeltingFuelLookup.getSolid();
            if (consume) {
                ItemStack extracted = handler.extractItem(i, 1, false);
                if (ItemStack.m_41656_((ItemStack)extracted, (ItemStack)stack)) {
                    ItemStack notInserted;
                    this.fuel += time;
                    this.fuelQuality = time;
                    this.temperature = solid.getTemperature();
                    this.rate = solid.getRate();
                    this.parent.setChangedFast();
                    ItemStack container = extracted.getCraftingRemainingItem();
                    if (!container.m_41619_() && !(notInserted = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)container, (boolean)false)).m_41619_()) {
                        Level world = this.getLevel();
                        double x = (double)(world.f_46441_.m_188501_() * 0.5f) + 0.25;
                        double y = (double)(world.f_46441_.m_188501_() * 0.5f) + 0.25;
                        double z = (double)(world.f_46441_.m_188501_() * 0.5f) + 0.25;
                        ItemEntity itementity = new ItemEntity(world, (double)this.fuelPos.m_123341_() + x, (double)this.fuelPos.m_123342_() + y, (double)this.fuelPos.m_123343_() + z, container);
                        itementity.m_32060_();
                        world.m_7967_((Entity)itementity);
                    }
                } else {
                    TConstruct.LOG.error("Invalid item removed from solid fuel handler");
                }
            }
            return solid.getTemperature();
        }
        return 0;
    }

    private void fetchHandlers() {
        if (this.fluidHandler != null && this.itemHandler != null) {
            return;
        }
        BlockEntity te = this.getLevel().m_7702_(this.fuelPos);
        if (te != null) {
            this.fluidHandler = te.getCapability(ForgeCapabilities.FLUID_HANDLER);
            if (this.fluidHandler.isPresent()) {
                this.fluidHandler.addListener(this.fluidListener);
            }
            this.itemHandler = te.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (this.itemHandler.isPresent()) {
                this.itemHandler.addListener(this.itemListener);
            }
        } else {
            this.fluidHandler = LazyOptional.empty();
            this.itemHandler = LazyOptional.empty();
        }
    }

    @Override
    public int findFuel(boolean consume) {
        this.fetchHandlers();
        assert (this.fluidHandler != null);
        assert (this.itemHandler != null);
        int temperature = 0;
        if (this.fluidHandler.isPresent()) {
            temperature = this.tryLiquidFuel((IFluidHandler)this.fluidHandler.orElse((Object)EmptyFluidHandler.INSTANCE), consume);
        }
        if (temperature == 0 && this.itemHandler.isPresent()) {
            temperature = this.trySolidFuel((IItemHandler)this.itemHandler.orElse((Object)EmptyItemHandler.INSTANCE), consume);
        }
        if (temperature == 0 && consume) {
            this.temperature = 0;
            this.rate = 0;
        }
        return temperature;
    }

    @Override
    public FuelModule.FuelInfo getFuelInfo() {
        this.fetchHandlers();
        assert (this.itemHandler != null);
        FuelModule.FuelInfo info = super.getFuelInfo();
        if (info.isEmpty() && this.itemHandler.isPresent()) {
            return FuelModule.FuelInfo.ITEM;
        }
        return info;
    }

    public IFluidHandler getTank() {
        if (this.fluidHandler != null) {
            return (IFluidHandler)this.fluidHandler.orElse((Object)EmptyFluidHandler.INSTANCE);
        }
        return EmptyFluidHandler.INSTANCE;
    }
}

