/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.display;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public interface TooltipModifierHook {
    public void addTooltip(IToolStackView var1, ModifierEntry var2, @Nullable Player var3, List<Component> var4, TooltipKey var5, TooltipFlag var6);

    public static Component statName(Modifier modifier, IToolStat<?> stat) {
        return Component.m_237115_((String)(modifier.getTranslationKey() + "." + stat.getName().m_135815_()));
    }

    public static void addFlatBoost(Modifier modifier, Component name, double bonus, List<Component> tooltip) {
        tooltip.add((Component)modifier.applyStyle(Component.m_237113_((String)(Util.BONUS_FORMAT.format(bonus) + " ")).m_7220_(name)));
    }

    public static void addPercentBoost(Modifier modifier, Component name, double bonus, List<Component> tooltip) {
        tooltip.add((Component)modifier.applyStyle(Component.m_237113_((String)(Util.PERCENT_BOOST_FORMAT.format(bonus) + " ")).m_7220_(name)));
    }

    public static void addStatBoost(IToolStackView tool, Modifier modifier, FloatToolStat stat, TagKey<Item> condition, float amount, List<Component> tooltip) {
        if (tool.hasTag(condition)) {
            TooltipModifierHook.addFlatBoost(modifier, TooltipModifierHook.statName(modifier, stat), amount * tool.getMultiplier(stat), tooltip);
        }
    }

    public static void addDamageBoost(IToolStackView tool, Modifier modifier, float amount, List<Component> tooltip) {
        TooltipModifierHook.addStatBoost(tool, modifier, ToolStats.ATTACK_DAMAGE, TinkerTags.Items.MELEE, amount, tooltip);
    }

    public static void addDamageBoost(IToolStackView tool, ModifierEntry modifier, float levelAmount, List<Component> tooltip) {
        TooltipModifierHook.addDamageBoost(tool, modifier.getModifier(), modifier.getEffectiveLevel() * levelAmount, tooltip);
    }

    public record AllMerger(Collection<TooltipModifierHook> modules) implements TooltipModifierHook
    {
        @Override
        public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
            for (TooltipModifierHook module : this.modules) {
                module.addTooltip(tool, modifier, player, tooltip, tooltipKey, tooltipFlag);
            }
        }
    }
}

