/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.configurations;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public class BOPTreeConfiguration
extends TreeConfiguration {
    public static final Codec<BOPTreeConfiguration> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockStateProvider.f_68747_.fieldOf("trunk_provider").forGetter(instance -> instance.f_68185_), (App)BlockStateProvider.f_68747_.fieldOf("foliage_provider").forGetter(instance -> instance.f_161213_), (App)BlockStateProvider.f_68747_.fieldOf("vine_provider").forGetter(instance -> instance.vineProvider), (App)BlockStateProvider.f_68747_.fieldOf("hanging_provider").forGetter(instance -> instance.hangingProvider), (App)BlockStateProvider.f_68747_.fieldOf("trunk_fruit_provider").forGetter(instance -> instance.trunkFruitProvider), (App)BlockStateProvider.f_68747_.fieldOf("alt_foliage_provider").forGetter(instance -> instance.altFoliageProvider), (App)Codec.INT.fieldOf("min_height").forGetter(instance -> instance.minHeight), (App)Codec.INT.fieldOf("max_height").forGetter(instance -> instance.maxHeight), (App)TreeDecorator.f_70021_.listOf().fieldOf("decorators").forGetter(instance -> instance.f_68187_)).apply((Applicative)builder, BOPTreeConfiguration::new));
    public final BlockStateProvider vineProvider;
    public final BlockStateProvider hangingProvider;
    public final BlockStateProvider trunkFruitProvider;
    public final BlockStateProvider altFoliageProvider;
    public final int minHeight;
    public final int maxHeight;

    protected BOPTreeConfiguration(BlockStateProvider trunkProvider, BlockStateProvider foliageProvider, BlockStateProvider vineProvider, BlockStateProvider hangingProvider, BlockStateProvider trunkFruitProvider, BlockStateProvider altFoliageProvider, int minHeight, int maxHeight, List<TreeDecorator> decorators) {
        super(trunkProvider, null, foliageProvider, null, null, null, (FeatureSize)new TwoLayersFeatureSize(1, 0, 1), decorators, false, false);
        this.vineProvider = vineProvider;
        this.hangingProvider = hangingProvider;
        this.trunkFruitProvider = trunkFruitProvider;
        this.altFoliageProvider = altFoliageProvider;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public static class Builder<T extends Builder> {
        protected BlockStateProvider trunkProvider = BlockStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
        protected BlockStateProvider foliageProvider = BlockStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
        protected BlockStateProvider vineProvider = BlockStateProvider.m_191384_((BlockState)Blocks.f_50016_.m_49966_());
        protected BlockStateProvider hangingProvider = BlockStateProvider.m_191384_((BlockState)Blocks.f_50016_.m_49966_());
        protected BlockStateProvider trunkFruitProvider = BlockStateProvider.m_191384_((BlockState)Blocks.f_50016_.m_49966_());
        protected BlockStateProvider altFoliageProvider = BlockStateProvider.m_191384_((BlockState)Blocks.f_50016_.m_49966_());
        protected List<TreeDecorator> decorators = Lists.newArrayList();
        protected int minHeight = 4;
        protected int maxHeight = 7;

        public T trunk(BlockStateProvider provider) {
            this.trunkProvider = provider;
            return (T)this;
        }

        public T foliage(BlockStateProvider provider) {
            this.foliageProvider = provider;
            return (T)this;
        }

        public T vine(BlockStateProvider provider) {
            this.vineProvider = provider;
            return (T)this;
        }

        public T hanging(BlockStateProvider provider) {
            this.hangingProvider = provider;
            return (T)this;
        }

        public T trunkFruit(BlockStateProvider provider) {
            this.trunkFruitProvider = provider;
            return (T)this;
        }

        public T altFoliage(BlockStateProvider a) {
            this.altFoliageProvider = a;
            return (T)this;
        }

        public T minHeight(int a) {
            this.minHeight = a;
            return (T)this;
        }

        public T maxHeight(int a) {
            this.maxHeight = a;
            return (T)this;
        }

        public T decorator(TreeDecorator decorator) {
            this.decorators.add(decorator);
            return (T)this;
        }

        public BOPTreeConfiguration build() {
            return new BOPTreeConfiguration(this.trunkProvider, this.foliageProvider, this.vineProvider, this.hangingProvider, this.trunkFruitProvider, this.altFoliageProvider, this.minHeight, this.maxHeight, this.decorators);
        }
    }
}

