/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.client;

import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.model.bakedmodels.WrappedItemModel;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.MultiIconTransformation;
import com.mojang.blaze3d.vertex.PoseStack;
import mrtjp.projectred.core.client.HaloRenderer;
import mrtjp.projectred.illumination.block.IllumarSmartLampBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class IllumarSmartLampItemRenderer
extends WrappedItemModel
implements IItemRenderer {
    private static final Cuboid6 BLOCK_BOUNDS = Cuboid6.full.copy().expand(-0.02);
    private static final Cuboid6 GLOW_BOUNDS = Cuboid6.full.copy().expand(0.02);
    private static final RandomSource random = RandomSource.m_216327_();
    private final byte[] signal = new byte[16];
    private long lastSignalAnimateTime = -1L;

    public IllumarSmartLampItemRenderer(BakedModel wrapped) {
        super(wrapped);
    }

    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.m_40614_();
        if (!(block instanceof IllumarSmartLampBlock)) {
            return;
        }
        IllumarSmartLampBlock block2 = (IllumarSmartLampBlock)block;
        TextureAtlasSprite[] icons = new TextureAtlasSprite[6];
        for (Direction dir : Direction.values()) {
            icons[dir.m_122411_()] = ((BakedQuad)this.wrapped.m_213637_(null, dir, random).get(0)).m_173410_();
        }
        MultiIconTransformation iconT = new MultiIconTransformation(icons);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.bind(RenderType.m_110463_(), getter, mStack);
        ccrs.setPipeline(new IVertexOperation[]{iconT});
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)BLOCK_BOUNDS, (int)0);
        this.animateSignal();
        HaloRenderer.renderInventoryMultiHalo((CCRenderState)ccrs, (PoseStack)mStack, (MultiBufferSource)getter, (Cuboid6)GLOW_BOUNDS, (Vector3)Vector3.ZERO, (byte[])this.signal);
        HaloRenderer.addItemRendererMultiBloom((ItemDisplayContext)transformType, (PoseStack)mStack, (Vector3)Vector3.ZERO, (Cuboid6)GLOW_BOUNDS, (byte[])this.signal);
    }

    private void animateSignal() {
        long time;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        long l = time = level != null ? level.m_46467_() : System.currentTimeMillis() / 50L;
        if (time == this.lastSignalAnimateTime) {
            return;
        }
        this.lastSignalAnimateTime = time;
        double t = (Math.sin((double)time / 200.0) + 1.0) / 2.0 * 15.0;
        double d = 1.5;
        for (int i = 0; i < 16; ++i) {
            double diff = Math.min(Math.abs(t - (double)i), d);
            double brightness = 1.0 - diff / d;
            this.signal[i] = (byte)(255.0 * brightness);
        }
    }

    @Nullable
    public PerspectiveModelState getModelState() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }
}

