/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import journeymap.common.Journeymap;
import journeymap.common.util.PermissionsManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class CreateWaypoint {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode waypoint = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"waypoint").requires(CreateWaypoint::canUseCommand)).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"color", (ArgumentType)ColorArgument.m_85463_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> CreateWaypoint.createWaypoint((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), Vec3Argument.m_120849_((CommandContext)ctx, (String)"location"), ColorArgument.m_85466_((CommandContext)ctx, (String)"color"), false))).then(Commands.m_82129_((String)"announce", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CreateWaypoint.createWaypoint((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), Vec3Argument.m_120849_((CommandContext)ctx, (String)"location"), ColorArgument.m_85466_((CommandContext)ctx, (String)"color"), BoolArgumentType.getBool((CommandContext)ctx, (String)"announce"))))))))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> CreateWaypoint.deleteWaypoint(EntityArgument.m_91477_((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), false))).then(Commands.m_82129_((String)"announce", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CreateWaypoint.deleteWaypoint(EntityArgument.m_91477_((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), BoolArgumentType.getBool((CommandContext)ctx, (String)"announce"))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wp").requires(CreateWaypoint::canUseCommand)).redirect((CommandNode)waypoint));
    }

    private static boolean canUseCommand(CommandSourceStack ctx) {
        return ctx.m_6761_(2) || ctx.m_81373_() != null && ctx.m_230897_() && PermissionsManager.getInstance().canServerAdmin((ServerPlayer)ctx.m_81373_()) || !ctx.m_81377_().m_6982_();
    }

    private static int deleteWaypoint(Collection<ServerPlayer> players, String name, boolean announce) {
        CommandWaypoint wp = new CommandWaypoint(name);
        CreateWaypoint.sendPacket(players, wp, "delete", announce);
        return 1;
    }

    private static int createWaypoint(CommandSourceStack source, Collection<ServerPlayer> players, String name, ServerLevel dimension, Coordinates location, ChatFormatting textFormatting, boolean announce) {
        CommandWaypoint wp = new CommandWaypoint(name, location.m_119568_(source), new Color(textFormatting.m_126665_()), dimension.m_46472_().m_135782_().toString());
        CreateWaypoint.sendPacket(players, wp, "create", announce);
        return 1;
    }

    private static void sendPacket(Collection<ServerPlayer> players, CommandWaypoint wp, String action, boolean announce) {
        players.forEach(player -> Journeymap.getInstance().getDispatcher().sendWaypointPacket((ServerPlayer)player, wp.toString(), announce, action));
    }

    public static class CommandWaypoint
    implements Serializable {
        public static final Gson GSON = new GsonBuilder().create();
        String id;
        public String name;
        String icon = "journeymap:ui/img/waypoint-icon.png";
        boolean enable = true;
        String type = "Normal";
        public String origin = "command";
        int x;
        int y;
        int z;
        int r;
        int g;
        int b;
        boolean persistent = true;
        List<String> dimensions;

        public CommandWaypoint(String name) {
            this.name = name;
        }

        public CommandWaypoint(String name, BlockPos pos, Color color, String dimensions) {
            this.name = name;
            this.x = pos.m_123341_();
            this.y = pos.m_123342_();
            this.z = pos.m_123343_();
            this.r = color.getRed();
            this.g = color.getGreen();
            this.b = color.getBlue();
            this.id = name + "_" + this.x + "," + this.y + "," + this.z;
            this.dimensions = Collections.singletonList(dimensions);
        }

        public String toString() {
            return GSON.toJson((Object)this);
        }

        public static CommandWaypoint fromString(String json) {
            return (CommandWaypoint)GSON.fromJson(json, CommandWaypoint.class);
        }
    }
}

