/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtphc2.items;

import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import maxhyper.dtphc2.blocks.FruitVineBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class FruitVineItem
extends BlockItem {
    FruitVineBlock vineBlock;

    public FruitVineItem(FruitVineBlock pBlock, Item.Properties pProperties) {
        super((Block)pBlock, pProperties);
        this.vineBlock = pBlock;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
        if (world == null) {
            return;
        }
        if (SeasonHelper.getSeasonValue((LevelContext)LevelContext.create((LevelAccessor)world), (BlockPos)BlockPos.f_121853_) == null) {
            return;
        }
        int flags = this.getSeasonalTooltipFlags(world);
        if (flags != 0) {
            tooltip.add((Component)Component.m_237113_((String)"desc.dynamictrees.seasonal.fertile_seasons").m_130946_(":"));
            if ((flags & 0xF) == 15) {
                tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.sereneseasons.year_round").m_130940_(ChatFormatting.LIGHT_PURPLE)));
            } else {
                if ((flags & 1) != 0) {
                    tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.sereneseasons.spring").m_130940_(ChatFormatting.GREEN)));
                }
                if ((flags & 2) != 0) {
                    tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.sereneseasons.summer").m_130940_(ChatFormatting.YELLOW)));
                }
                if ((flags & 4) != 0) {
                    tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.sereneseasons.autumn").m_130940_(ChatFormatting.GOLD)));
                }
                if ((flags & 8) != 0) {
                    tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.sereneseasons.winter").m_130940_(ChatFormatting.AQUA)));
                }
            }
        }
    }

    public int getSeasonalTooltipFlags(Level world) {
        float seasonStart = 0.16666667f;
        float seasonEnd = 0.8333333f;
        float threshold = 0.75f;
        Float seasonOffset = this.vineBlock.getSeasonOffset();
        int seasonFlags = 0;
        for (int i = 0; i < 4; ++i) {
            boolean isValidSeason = false;
            if (seasonOffset != null) {
                float prod2;
                LevelContext levelContext = LevelContext.create((LevelAccessor)world);
                float prod1 = SeasonHelper.globalSeasonalFruitProductionFactor((LevelContext)levelContext, (BlockPos)new BlockPos(0, (int)(((float)i + 0.16666667f - seasonOffset.floatValue()) * 64.0f), 0), (boolean)true);
                if (Math.min(prod1, prod2 = SeasonHelper.globalSeasonalFruitProductionFactor((LevelContext)levelContext, (BlockPos)new BlockPos(0, (int)(((float)i + 0.8333333f - seasonOffset.floatValue()) * 64.0f), 0), (boolean)true)) > 0.75f) {
                    isValidSeason = true;
                }
            } else {
                isValidSeason = true;
            }
            if (!isValidSeason) continue;
            seasonFlags |= 1 << i;
        }
        return seasonFlags;
    }
}

