/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.fusion.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import mod.alexndr.fusion.datagen.FusionBlockStateProvider;
import mod.alexndr.fusion.datagen.FusionItemModelProvider;
import mod.alexndr.fusion.datagen.FusionLootInjectorSubprovider;
import mod.alexndr.fusion.datagen.FusionLootTableSubprovider;
import mod.alexndr.fusion.datagen.FusionRecipes;
import mod.alexndr.fusion.datagen.ModBlockTags;
import mod.alexndr.fusion.datagen.ModItemTags;
import mod.alexndr.fusion.datagen.Recipes;
import mod.alexndr.simplecorelib.api.datagen.SimpleLootTableProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fusion", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FusionDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        ModBlockTags blockTags = new ModBlockTags(packOutput, lookupProvider, existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ModItemTags(packOutput, lookupProvider, blockTags.m_274426_(), event.getExistingFileHelper()));
        gen.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput));
        gen.addProvider(event.includeServer(), (DataProvider)new FusionRecipes(packOutput));
        gen.addProvider(event.includeServer(), (DataProvider)new SimpleLootTableProvider(packOutput, List.of(new LootTableProvider.SubProviderEntry(FusionLootTableSubprovider::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(FusionLootInjectorSubprovider::new, LootContextParamSets.f_81411_))));
        gen.addProvider(event.includeClient(), (DataProvider)new FusionBlockStateProvider(packOutput, event.getExistingFileHelper()));
        gen.addProvider(event.includeClient(), (DataProvider)new FusionItemModelProvider(packOutput, event.getExistingFileHelper()));
    }
}

