/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.fusion.datagen;

import mod.alexndr.fusion.init.ModBlocks;
import mod.alexndr.simplecorelib.api.content.MultifunctionPressurePlateBlock;
import mod.alexndr.simplecorelib.api.datagen.SimpleBlockStateProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class FusionBlockStateProvider
extends SimpleBlockStateProvider {
    public FusionBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "fusion", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.doorStatesAndModels();
        this.barStatesAndModels();
        this.pressurePlateStatesAndModels();
    }

    private void barStatesAndModels() {
        this.basicBlockItem((Block)ModBlocks.bronze_bars.get());
        this.basicBlockItem((Block)ModBlocks.steel_bars.get());
        this.basicBlockItem((Block)ModBlocks.thyrium_bars.get());
        this.basicBlockItem((Block)ModBlocks.sinisite_bars.get());
        this.buildBarsBlockState((IronBarsBlock)ModBlocks.bronze_bars.get(), this.modLoc("block/bronze_bars"));
        this.buildBarsBlockState((IronBarsBlock)ModBlocks.steel_bars.get(), this.modLoc("block/steel_bars"));
        this.buildBarsBlockState((IronBarsBlock)ModBlocks.thyrium_bars.get(), this.modLoc("block/thyrium_bars"));
        this.buildBarsBlockState((IronBarsBlock)ModBlocks.sinisite_bars.get(), this.modLoc("block/sinisite_bars"));
    }

    private void doorStatesAndModels() {
        this.itemModels().basicItem(((DoorBlock)ModBlocks.bronze_door.get()).m_5456_());
        this.itemModels().basicItem(((DoorBlock)ModBlocks.steel_door.get()).m_5456_());
        this.itemModels().basicItem(((DoorBlock)ModBlocks.sinisite_door.get()).m_5456_());
        this.itemModels().basicItem(((DoorBlock)ModBlocks.thyrium_door.get()).m_5456_());
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.bronze_door.get(), this.modLoc("block/bronze_door_lower"), this.modLoc("block/bronze_door_upper"), "cutout");
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.steel_door.get(), this.modLoc("block/steel_door_lower"), this.modLoc("block/steel_door_upper"), "cutout");
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.sinisite_door.get(), this.modLoc("block/sinisite_door_bottom"), this.modLoc("block/sinisite_door_top"), "cutout");
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.thyrium_door.get(), this.modLoc("block/thyrium_door_bottom"), this.modLoc("block/thyrium_door_top"), "cutout");
    }

    private void pressurePlateStatesAndModels() {
        ModelBuilder bronzePlateModel = this.models().pressurePlate("bronze_plate", new ResourceLocation("fusion", "block/bronze_block"));
        ModelBuilder bronzePlateModel_down = this.models().pressurePlateDown("bronze_plate_down", new ResourceLocation("fusion", "block/bronze_block"));
        ModelBuilder steelPlateModel = this.models().pressurePlate("steel_plate", new ResourceLocation("fusion", "block/steel_block"));
        ModelBuilder steelPlateModel_down = this.models().pressurePlateDown("steel_plate_down", new ResourceLocation("fusion", "block/steel_block"));
        ModelBuilder sinisitePlateModel = this.models().pressurePlate("sinisite_plate", new ResourceLocation("fusion", "block/sinisite_block"));
        ModelBuilder sinisitePlateModel_down = this.models().pressurePlateDown("sinisite_plate_down", new ResourceLocation("fusion", "block/sinisite_block"));
        ModelBuilder thyriumPlateModel = this.models().pressurePlate("thyrium_plate", new ResourceLocation("fusion", "block/thyrium_block"));
        ModelBuilder thyriumPlateModel_down = this.models().pressurePlateDown("thyrium_plate_down", new ResourceLocation("fusion", "block/thyrium_block"));
        this.itemModels().withExistingParent("bronze_pressure_plate", new ResourceLocation("fusion", "block/bronze_plate"));
        this.itemModels().withExistingParent("steel_pressure_plate", new ResourceLocation("fusion", "block/steel_plate"));
        this.itemModels().withExistingParent("sinisite_pressure_plate", new ResourceLocation("fusion", "block/sinisite_plate"));
        this.itemModels().withExistingParent("thyrium_pressure_plate", new ResourceLocation("fusion", "block/thyrium_plate"));
        this.buildWeightedPressurePlateBlockState((MultifunctionPressurePlateBlock)ModBlocks.bronze_pressure_plate.get(), (ModelFile)bronzePlateModel, (ModelFile)bronzePlateModel_down);
        this.buildWeightedPressurePlateBlockState((MultifunctionPressurePlateBlock)ModBlocks.steel_pressure_plate.get(), (ModelFile)steelPlateModel, (ModelFile)steelPlateModel_down);
        this.buildWeightedPressurePlateBlockState((MultifunctionPressurePlateBlock)ModBlocks.sinisite_pressure_plate.get(), (ModelFile)sinisitePlateModel, (ModelFile)sinisitePlateModel_down);
        this.buildWeightedPressurePlateBlockState((MultifunctionPressurePlateBlock)ModBlocks.thyrium_pressure_plate.get(), (ModelFile)thyriumPlateModel, (ModelFile)thyriumPlateModel_down);
    }
}

