/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.fusion.client.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mod.alexndr.fusion.api.recipe.FusionRecipe;
import mod.alexndr.fusion.api.recipe.IFusionRecipe;
import mod.alexndr.fusion.client.gui.FusionFurnaceScreen;
import mod.alexndr.fusion.client.jei.FusionFuelCategory;
import mod.alexndr.fusion.client.jei.FusionFuelRecipeMaker;
import mod.alexndr.fusion.client.jei.FusionFurnaceFuelRecipe;
import mod.alexndr.fusion.client.jei.FusionFurnaceRecipeCategory;
import mod.alexndr.fusion.client.jei.FusionRecipeMaker;
import mod.alexndr.fusion.content.FusionFurnaceBlock;
import mod.alexndr.fusion.content.FusionFurnaceContainer;
import mod.alexndr.fusion.init.ModBlocks;
import mod.alexndr.fusion.init.ModContainers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIFusionPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("fusion", "fusion_furnace_plugin");
    public static final RecipeType<IFusionRecipe> FUSION_RECIPE_TYPE = RecipeType.create((String)"fusion", (String)"alloying", FusionRecipe.class);
    public static final RecipeType<FusionFurnaceFuelRecipe> FUSION_FUEL_RECIPE_TYPE = RecipeType.create((String)"fusion", (String)"fusion_furnace_fuel", FusionFurnaceFuelRecipe.class);

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.fusion_furnace.get()), new RecipeType[]{FUSION_RECIPE_TYPE, FUSION_FUEL_RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FusionFurnaceRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FusionFuelCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            throw new NullPointerException("Minecraft world must not be null");
        }
        RecipeManager recipeManager = world.m_7465_();
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IIngredientManager ingredientManager = registration.getIngredientManager();
        registration.addRecipes(FUSION_RECIPE_TYPE, FusionRecipeMaker.getFusionRecipes(recipeManager));
        registration.addRecipes(FUSION_FUEL_RECIPE_TYPE, FusionFuelRecipeMaker.getFuelRecipes(ingredientManager, jeiHelpers));
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)((FusionFurnaceBlock)((Object)ModBlocks.fusion_furnace.get())).m_5456_()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"fusion.fusion_furnace.info")});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(FusionFurnaceContainer.class, (MenuType)ModContainers.FUSION_FURNACE.get(), FUSION_RECIPE_TYPE, 0, 3, 5, 36);
        registration.addRecipeTransferHandler(FusionFurnaceContainer.class, (MenuType)ModContainers.FUSION_FURNACE.get(), FUSION_FUEL_RECIPE_TYPE, 4, 1, 5, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(FusionFurnaceScreen.class, 2, 2, 70, 31, new RecipeType[]{FUSION_RECIPE_TYPE});
        registration.addRecipeClickArea(FusionFurnaceScreen.class, 105, 2, 70, 31, new RecipeType[]{FUSION_FUEL_RECIPE_TYPE});
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

