/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.fusion.client.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mod.alexndr.fusion.api.recipe.IFusionRecipe;
import mod.alexndr.fusion.client.jei.JEIFusionPlugin;
import mod.alexndr.fusion.init.ModBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FusionFurnaceRecipeCategory
implements IRecipeCategory<IFusionRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("fusion", "alloying");
    private final IDrawable background;
    private final Component localizedName;
    private final ResourceLocation backgroundLocation;
    private final IDrawableAnimated flame;
    private final IDrawableAnimated arrow_left;
    private final IDrawableAnimated arrow_right;
    private final IDrawableAnimated bubble_left;
    private final IDrawableAnimated bubble_right;
    private final IDrawable icon;

    public FusionFurnaceRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.fusion_furnace.get()));
        this.localizedName = Component.m_237115_((String)"fusion.jei.fusion_category");
        this.backgroundLocation = new ResourceLocation("fusion", "textures/gui/container/fusion_furnace_gui.png");
        this.background = guiHelper.createDrawable(this.backgroundLocation, 32, 4, 110, 74);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(this.backgroundLocation, 176, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 300, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic arrowDrawable1 = guiHelper.createDrawable(this.backgroundLocation, 176, 14, 24, 17);
        this.arrow_left = guiHelper.createAnimatedDrawable(arrowDrawable1, 200, IDrawableAnimated.StartDirection.LEFT, false);
        IDrawableStatic arrowDrawable2 = guiHelper.createDrawable(this.backgroundLocation, 176, 31, 24, 17);
        this.arrow_right = guiHelper.createAnimatedDrawable(arrowDrawable2, 200, IDrawableAnimated.StartDirection.RIGHT, false);
        IDrawableStatic bubbleDrawable1 = guiHelper.createDrawable(this.backgroundLocation, 176, 64, 12, 28);
        this.bubble_left = guiHelper.createAnimatedDrawable(bubbleDrawable1, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
        IDrawableStatic bubbleDrawable2 = guiHelper.createDrawable(this.backgroundLocation, 188, 64, 12, 28);
        this.bubble_right = guiHelper.createAnimatedDrawable(bubbleDrawable2, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void draw(IFusionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.flame.draw(guiGraphics, 23, 51);
        this.flame.draw(guiGraphics, 73, 51);
        this.arrow_left.draw(guiGraphics, 19, 30);
        this.arrow_right.draw(guiGraphics, 68, 30);
        this.bubble_left.draw(guiGraphics, 32, 0);
        this.bubble_right.draw(guiGraphics, 66, 0);
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            String experienceString = I18n.m_118938_((String)"gui.jei.category.fusion.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92895_(experienceString);
            guiGraphics.m_280056_(fontRenderer, experienceString, this.background.getWidth() - stringWidth, 0, -8355712, false);
        }
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IFusionRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 30).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 93, 30).addIngredients((Ingredient)recipe.m_7527_().get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 46, 2).addIngredients(recipe.getCatalyst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 46, 28).addItemStack(recipe.m_8043_(null));
    }

    public RecipeType<IFusionRecipe> getRecipeType() {
        return JEIFusionPlugin.FUSION_RECIPE_TYPE;
    }
}

