/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.fusion.client.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mod.alexndr.fusion.api.content.AbstractAlloyFurnaceTileEntity;
import mod.alexndr.fusion.api.helpers.ErrorUtil;
import mod.alexndr.fusion.client.jei.FusionFurnaceFuelRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FusionFuelRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();

    private FusionFuelRecipeMaker() {
    }

    public static List<FusionFurnaceFuelRecipe> getFuelRecipes(IIngredientManager ingredientManager, IJeiHelpers helpers) {
        Collection allItemStacks = ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK);
        ArrayList<FusionFurnaceFuelRecipe> fuelRecipes = new ArrayList<FusionFurnaceFuelRecipe>();
        for (ItemStack stack : allItemStacks) {
            int burnTime = FusionFuelRecipeMaker.getBurnTime(stack);
            if (burnTime <= 0) continue;
            fuelRecipes.add(new FusionFurnaceFuelRecipe(Collections.singleton(stack), burnTime));
        }
        return fuelRecipes;
    }

    private static int getBurnTime(ItemStack itemStack) {
        try {
            return (int)Math.ceil((double)ForgeHooks.getBurnTime((ItemStack)itemStack, null) * AbstractAlloyFurnaceTileEntity.BURN_TIME_MODIFIER);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Failed to check if item is fuel {}.", (Object)itemStackInfo, (Object)e);
            return 0;
        }
    }
}

