/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.fusion.api.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mod.alexndr.fusion.Fusion;
import mod.alexndr.fusion.api.client.ClientOnlyWrapper;
import mod.alexndr.fusion.api.recipe.IFusionRecipe;
import mod.alexndr.fusion.init.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.server.ServerLifecycleHooks;

public class FusionRecipe
implements IFusionRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> inputs;
    private final Ingredient catalyst;
    private final int cook_time;
    private final float experience;
    private final int INPUT1_SLOT = 0;
    private final int INPUT2_SLOT = 1;
    private final int CATALYST_SLOT = 2;
    private static Set<Item> legal_inputs = new HashSet<Item>();
    private static Set<Item> legal_catalysts = new HashSet<Item>();

    public FusionRecipe(ResourceLocation id, ItemStack output, int cook_time, float experience, Ingredient catalyst, Ingredient ... inputs) {
        this.id = id;
        this.output = output;
        this.inputs = NonNullList.m_122783_(null, (Object[])inputs);
        this.catalyst = catalyst;
        this.cook_time = cook_time;
        this.experience = experience;
    }

    private static void initLegalisms() {
        Fusion.LOGGER.info("fusion: in FusionRecipe.InitLegalisms()");
        List recipes = FMLEnvironment.dist == Dist.CLIENT ? ClientOnlyWrapper.getRecipeManager().m_44013_((RecipeType)ModRecipeTypes.FUSION_TYPE.get()) : ServerLifecycleHooks.getCurrentServer().m_129894_().m_44013_((RecipeType)ModRecipeTypes.FUSION_TYPE.get());
        for (IFusionRecipe recipe : recipes) {
            NonNullList ingrs = recipe.m_7527_();
            for (Ingredient ingr : ingrs) {
                for (ItemStack stack : ingr.m_43908_()) {
                    legal_inputs.add(stack.m_41720_());
                }
            }
            for (ItemStack stack : ((FusionRecipe)recipe).getCatalyst().m_43908_()) {
                legal_catalysts.add(stack.m_41720_());
            }
        }
    }

    public static boolean isInput(ItemStack stack) {
        if (legal_inputs.isEmpty()) {
            FusionRecipe.initLegalisms();
        }
        return legal_inputs.contains(stack.m_41720_());
    }

    public static boolean isCatalyst(ItemStack stack) {
        if (legal_catalysts.isEmpty()) {
            FusionRecipe.initLegalisms();
        }
        return legal_catalysts.contains(stack.m_41720_());
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        ItemStack input;
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int ii = 0; ii <= 1 && !(input = inv.m_8020_(ii)).m_41619_(); ++ii) {
            int stackIndex = -1;
            for (int jj = 0; jj < ingredientsMissing.size(); ++jj) {
                Ingredient ingr = (Ingredient)ingredientsMissing.get(jj);
                if (!ingr.test(input)) continue;
                stackIndex = jj;
                break;
            }
            if (stackIndex == -1) {
                return false;
            }
            ingredientsMissing.remove(stackIndex);
        }
        ItemStack cata = inv.m_8020_(2);
        if (this.catalyst.test(cata)) {
            return ingredientsMissing.isEmpty();
        }
        return false;
    }

    public ItemStack assemble(RecipeWrapper pContainer, RegistryAccess pRegistryAccess) {
        return this.m_8043_(pRegistryAccess).m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output;
    }

    @Override
    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getCookTime() {
        return this.cook_time;
    }

    @Override
    public float getExperience() {
        return this.experience;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.FUSION_SERIALIZER.get();
    }

    public static class FusionRecipeSerializer
    implements RecipeSerializer<FusionRecipe> {
        public FusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"), (boolean)true);
            JsonArray ingrs = GsonHelper.m_13933_((JsonObject)json, (String)"inputs");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.m_43917_((JsonElement)e));
            }
            Ingredient catalyst = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"catalyst"));
            int cook_time = GsonHelper.m_13927_((JsonObject)json, (String)"cookingtime");
            float experience = GsonHelper.m_13915_((JsonObject)json, (String)"experience");
            return new FusionRecipe(recipeId, output, cook_time, experience, catalyst, inputs.toArray(new Ingredient[0]));
        }

        public FusionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
            Ingredient[] inputs = new Ingredient[buf.m_130242_()];
            for (int ii = 0; ii < inputs.length; ++ii) {
                inputs[ii] = Ingredient.m_43940_((FriendlyByteBuf)buf);
            }
            ItemStack output = buf.m_130267_();
            Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)buf);
            int cook_time = buf.m_130242_();
            float exp = buf.readFloat();
            return new FusionRecipe(recipeId, output, cook_time, exp, catalyst, inputs);
        }

        public void toNetwork(FriendlyByteBuf buf, FusionRecipe recipe) {
            buf.m_130130_(recipe.m_7527_().size());
            for (Ingredient input : recipe.m_7527_()) {
                input.m_43923_(buf);
            }
            buf.writeItemStack(recipe.m_8043_(null), true);
            recipe.getCatalyst().m_43923_(buf);
            buf.m_130130_(recipe.getCookTime());
            buf.writeFloat(recipe.getExperience());
        }
    }
}

