/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.fusion.api.datagen;

import java.util.List;
import java.util.function.Consumer;
import mod.alexndr.fusion.api.datagen.AbstractFusionRecipeProvider;
import mod.alexndr.simplecorelib.api.datagen.RecipeSetBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class FusionRecipeSetBuilder
extends RecipeSetBuilder {
    public FusionRecipeSetBuilder(String modid) {
        super(modid);
    }

    public void buildBasicAlloyRecipes(Consumer<FinishedRecipe> consumer, List<Ingredient> primaryInputs, Ingredient[] catalysts, ItemLike nugget, ItemLike medium_chunk, ItemLike large_chunk, float experience, int cooktime, ICondition condition) {
        this.buildBasicAlloyRecipes(consumer, primaryInputs, catalysts, nugget, medium_chunk, large_chunk, experience, cooktime, condition, null);
    }

    public void buildBasicAlloyRecipes(Consumer<FinishedRecipe> consumer, List<Ingredient> primaryInputs, Ingredient[] catalysts, ItemLike nugget, ItemLike medium_chunk, ItemLike large_chunk, float experience, int cooktime, ICondition condition, String suffix) {
        ResourceLocation large_chunk_name;
        if (suffix == null) {
            suffix = "";
        }
        ResourceLocation nugget_name = nugget != null ? AbstractFusionRecipeProvider.id(this.modid, nugget.m_5456_().toString() + suffix) : null;
        ResourceLocation medium_chunk_name = medium_chunk != null ? AbstractFusionRecipeProvider.id(this.modid, medium_chunk.m_5456_().toString() + suffix) : null;
        ResourceLocation resourceLocation = large_chunk_name = large_chunk != null ? AbstractFusionRecipeProvider.id(this.modid, large_chunk.m_5456_().toString() + suffix) : null;
        if (condition == null) {
            if (nugget != null) {
                consumer.accept(new AbstractFusionRecipeProvider.FinishedFusionRecipe(nugget_name, new ItemStack((ItemLike)nugget.m_5456_()), cooktime, experience, catalysts[0], primaryInputs.get(0), primaryInputs.get(1)));
            }
            if (medium_chunk != null) {
                consumer.accept(new AbstractFusionRecipeProvider.FinishedFusionRecipe(medium_chunk_name, new ItemStack((ItemLike)medium_chunk.m_5456_()), cooktime, experience * 2.0f, catalysts[1], primaryInputs.get(0), primaryInputs.get(1)));
            }
            if (large_chunk != null) {
                consumer.accept(new AbstractFusionRecipeProvider.FinishedFusionRecipe(large_chunk_name, new ItemStack((ItemLike)large_chunk.m_5456_()), cooktime, experience * 4.0f, catalysts[2], primaryInputs.get(0), primaryInputs.get(1)));
            }
        } else {
            if (nugget != null) {
                ConditionalRecipe.builder().addCondition(condition).addRecipe((FinishedRecipe)new AbstractFusionRecipeProvider.FinishedFusionRecipe(nugget_name, new ItemStack((ItemLike)nugget.m_5456_()), cooktime, experience, catalysts[0], primaryInputs.get(0), primaryInputs.get(1))).build(consumer, nugget_name);
            }
            if (medium_chunk != null) {
                ConditionalRecipe.builder().addCondition(condition).addRecipe((FinishedRecipe)new AbstractFusionRecipeProvider.FinishedFusionRecipe(medium_chunk_name, new ItemStack((ItemLike)medium_chunk.m_5456_()), cooktime, experience * 2.0f, catalysts[1], primaryInputs.get(0), primaryInputs.get(1))).build(consumer, medium_chunk_name);
            }
            if (large_chunk != null) {
                ConditionalRecipe.builder().addCondition(condition).addRecipe((FinishedRecipe)new AbstractFusionRecipeProvider.FinishedFusionRecipe(large_chunk_name, new ItemStack((ItemLike)large_chunk.m_5456_()), cooktime, experience * 4.0f, catalysts[2], primaryInputs.get(0), primaryInputs.get(1))).build(consumer, large_chunk_name);
            }
        }
    }

    public void buildFusionRecyclingRecipes(Consumer<FinishedRecipe> consumer, Ingredient ingredients, Ingredient ingrs_doubleoutput, Ingredient input2, Ingredient catalyst, ItemLike output_item, float experience, int cooktime, ICondition condition, String name) {
        ResourceLocation recipe1 = AbstractFusionRecipeProvider.id(this.modid, name + "1");
        if (ingredients != null) {
            ConditionalRecipe.builder().addCondition(condition).addRecipe((FinishedRecipe)new AbstractFusionRecipeProvider.FinishedFusionRecipe(recipe1, new ItemStack((ItemLike)output_item.m_5456_()), cooktime, experience, catalyst, ingredients, input2)).build(consumer, recipe1);
        }
        if (ingrs_doubleoutput != null) {
            ResourceLocation recipe2 = AbstractFusionRecipeProvider.id(this.modid, name + "2");
            ConditionalRecipe.builder().addCondition(condition).addRecipe((FinishedRecipe)new AbstractFusionRecipeProvider.FinishedFusionRecipe(recipe2, new ItemStack((ItemLike)output_item.m_5456_(), 2), cooktime, experience * 2.0f, catalyst, ingrs_doubleoutput, input2)).build(consumer, recipe2);
        }
    }
}

