/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.fusion.api.content;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.alexndr.fusion.api.content.AbstractAlloyFurnaceBlock;
import mod.alexndr.fusion.api.recipe.FusionRecipe;
import mod.alexndr.fusion.api.recipe.IFusionRecipe;
import mod.alexndr.fusion.init.ModRecipeTypes;
import mod.alexndr.simplecorelib.api.helpers.SidedWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractAlloyFurnaceTileEntity
extends BlockEntity {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final int INPUT1_SLOT = 0;
    public static final int INPUT2_SLOT = 1;
    public static final int CATALYST_SLOT = 2;
    public static final int OUTPUT_SLOT = 3;
    public static final int FUEL_SLOT = 4;
    public static final int DATA_FUEL_TIME_LEFT = 0;
    public static final int DATA_FUEL_TIME_MAX = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static double BURN_TIME_MODIFIER = 1.875;
    public static int DEFAULT_ALLOY_TIME = 600;
    protected static final String INVENTORY_TAG = "inventory";
    protected static final String SMELT_TIME_LEFT_TAG = "smeltTimeLeft";
    protected static final String MAX_SMELT_TIME_TAG = "maxSmeltTime";
    protected static final String FUEL_BURN_TIME_LEFT_TAG = "fuelBurnTimeLeft";
    protected static final String MAX_FUEL_BURN_TIME_TAG = "maxFuelBurnTime";
    public int smeltTimeProgress = 0;
    public int maxSmeltTime = -1;
    public int fuelBurnTimeLeft = -1;
    public int maxFuelBurnTime = -1;
    protected boolean lastBurning = false;
    private final Map<ResourceLocation, Integer> recipe2xp_map = Maps.newHashMap();
    protected boolean hasFuelMultiplier = false;
    protected double fuelMultiplier = 1.0;
    protected int YieldChance = 0;
    protected int YieldAmount = 0;
    protected Random generator = new Random();
    protected IFusionRecipe cachedRecipe;
    protected ItemStack failedMatch1 = ItemStack.f_41583_;
    protected ItemStack failedMatch2 = ItemStack.f_41583_;
    protected ItemStack failedMatchC = ItemStack.f_41583_;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return AbstractAlloyFurnaceTileEntity.this.fuelBurnTimeLeft;
                }
                case 1: {
                    return AbstractAlloyFurnaceTileEntity.this.maxFuelBurnTime;
                }
                case 2: {
                    return AbstractAlloyFurnaceTileEntity.this.smeltTimeProgress;
                }
                case 3: {
                    return AbstractAlloyFurnaceTileEntity.this.maxSmeltTime;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractAlloyFurnaceTileEntity.this.fuelBurnTimeLeft = value;
                    break;
                }
                case 1: {
                    AbstractAlloyFurnaceTileEntity.this.maxFuelBurnTime = value;
                    break;
                }
                case 2: {
                    AbstractAlloyFurnaceTileEntity.this.smeltTimeProgress = value;
                    break;
                }
                case 3: {
                    AbstractAlloyFurnaceTileEntity.this.maxSmeltTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    public final ItemStackHandler inventory = new ItemStackHandler(5){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            switch (slot) {
                case 4: {
                    return AbstractAlloyFurnaceTileEntity.this.isFuel(stack);
                }
                case 0: 
                case 1: {
                    return AbstractAlloyFurnaceTileEntity.this.isInput(stack);
                }
                case 2: {
                    return AbstractAlloyFurnaceTileEntity.this.isCatalyst(stack);
                }
                case 3: {
                    return AbstractAlloyFurnaceTileEntity.this.isOutput(stack);
                }
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            AbstractAlloyFurnaceTileEntity.this.m_6596_();
        }
    };
    protected LazyOptional<ItemStackHandler> inventoryCapabilityInternal = LazyOptional.of(() -> this.inventory);
    protected LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalUp = LazyOptional.of(() -> new AlloyFurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.UP));
    protected LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalLeft = LazyOptional.of(() -> new AlloyFurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.EAST));
    protected LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalRight = LazyOptional.of(() -> new AlloyFurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.WEST));
    protected LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown = LazyOptional.of(() -> new AlloyFurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.DOWN));
    protected LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalBack = LazyOptional.of(() -> new AlloyFurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.SOUTH));

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.inventoryCapabilityInternal.cast();
            }
            Direction actual_facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Direction default_facing = Direction.NORTH;
            Direction true_side = side == Direction.UP || side == Direction.DOWN ? side : (actual_facing.m_122424_() == default_facing ? side.m_122424_() : (actual_facing.m_122427_() == default_facing ? side.m_122427_() : (actual_facing.m_122428_() == default_facing ? side.m_122428_() : side)));
            switch (true_side) {
                case DOWN: {
                    return this.inventoryCapabilityExternalDown.cast();
                }
                case UP: {
                    return this.inventoryCapabilityExternalUp.cast();
                }
                case NORTH: 
                case SOUTH: {
                    return this.inventoryCapabilityExternalBack.cast();
                }
                case WEST: {
                    return this.inventoryCapabilityExternalRight.cast();
                }
                case EAST: {
                    return this.inventoryCapabilityExternalLeft.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapabilityInternal.invalidate();
        this.inventoryCapabilityExternalUp.invalidate();
        this.inventoryCapabilityExternalDown.invalidate();
        this.inventoryCapabilityExternalBack.invalidate();
        this.inventoryCapabilityExternalLeft.invalidate();
        this.inventoryCapabilityExternalRight.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.inventoryCapabilityInternal = LazyOptional.of(() -> this.inventory);
        this.inventoryCapabilityExternalUp = LazyOptional.of(() -> new AlloyFurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.UP));
        this.inventoryCapabilityExternalLeft = LazyOptional.of(() -> new AlloyFurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.EAST));
        this.inventoryCapabilityExternalRight = LazyOptional.of(() -> new AlloyFurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.WEST));
        this.inventoryCapabilityExternalDown = LazyOptional.of(() -> new AlloyFurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.DOWN));
        this.inventoryCapabilityExternalBack = LazyOptional.of(() -> new AlloyFurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.SOUTH));
    }

    public AbstractAlloyFurnaceTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos blockpos, BlockState blockstate) {
        super(tileEntityTypeIn, blockpos, blockstate);
    }

    protected boolean isInput(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        boolean is_input = FusionRecipe.isInput(stack);
        return is_input;
    }

    protected boolean isCatalyst(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        boolean is_cata = FusionRecipe.isCatalyst(stack);
        return is_cata;
    }

    protected boolean isOutput(ItemStack stack) {
        Optional<ItemStack> result = this.getResult(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1), this.inventory.getStackInSlot(2));
        return result.isPresent() && ItemStack.m_41656_((ItemStack)result.get(), (ItemStack)stack);
    }

    public boolean isFuel(ItemStack stack) {
        return FurnaceBlockEntity.m_58399_((ItemStack)stack);
    }

    public boolean isBurning() {
        return this.fuelBurnTimeLeft > 0;
    }

    private Optional<IFusionRecipe> getRecipe(ItemStack input1, ItemStack input2, ItemStack catalyst) {
        if (input1.m_41619_() || input2.m_41619_() || catalyst.m_41619_() || input1 == this.failedMatch1 && input2 == this.failedMatch2 && catalyst == this.failedMatchC) {
            return Optional.empty();
        }
        return this.getRecipe((Container)new SimpleContainer(new ItemStack[]{input1, input2, catalyst}));
    }

    private Optional<IFusionRecipe> getRecipe(Container inv) {
        RecipeWrapper inv0 = new RecipeWrapper((IItemHandlerModifiable)new InvWrapper(inv));
        if (this.cachedRecipe != null && this.cachedRecipe.m_5818_((Container)inv0, this.f_58857_)) {
            return Optional.of(this.cachedRecipe);
        }
        IFusionRecipe rec = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.FUSION_TYPE.get(), (Container)inv0, this.f_58857_).orElse(null);
        if (rec == null) {
            this.failedMatch1 = inv.m_8020_(0);
            this.failedMatch2 = inv.m_8020_(1);
            this.failedMatchC = inv.m_8020_(2);
        } else {
            this.failedMatch1 = ItemStack.f_41583_;
            this.failedMatch2 = ItemStack.f_41583_;
            this.failedMatchC = ItemStack.f_41583_;
        }
        this.cachedRecipe = rec;
        return Optional.ofNullable(rec);
    }

    private Optional<ItemStack> getResult(ItemStack input1, ItemStack input2, ItemStack catalyst) {
        RecipeWrapper inv0 = new RecipeWrapper((IItemHandlerModifiable)new InvWrapper((Container)new SimpleContainer(new ItemStack[]{input1, input2, catalyst})));
        Optional<ItemStack> maybe_result = this.getRecipe(input1, input2, catalyst).map(recipe -> recipe.m_5874_((Container)inv0, this.m_58904_().m_9598_()));
        return Optional.of(maybe_result.orElse(ItemStack.f_41583_));
    }

    public void setRecipeUsed(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            this.recipe2xp_map.compute(recipe.m_6423_(), (p_214004_0_, p_214004_1_) -> 1 + (p_214004_1_ == null ? 0 : p_214004_1_));
        }
    }

    protected int getBurnDuration(ItemStack fuelstack) {
        int returnval = 0;
        returnval = !this.hasFuelMultiplier ? (int)Math.ceil((double)ForgeHooks.getBurnTime((ItemStack)fuelstack, null) * BURN_TIME_MODIFIER) : (int)Math.ceil((double)ForgeHooks.getBurnTime((ItemStack)fuelstack, null) * this.fuelMultiplier * BURN_TIME_MODIFIER);
        return returnval;
    }

    protected boolean canSmelt(ItemStack result) {
        if (!(this.inventory.getStackInSlot(0).m_41619_() || this.inventory.getStackInSlot(1).m_41619_() || this.inventory.getStackInSlot(2).m_41619_() || result.m_41619_())) {
            ItemStack outstack = this.inventory.getStackInSlot(3);
            if (outstack.m_41619_()) {
                return true;
            }
            if (!outstack.m_150930_(result.m_41720_())) {
                return false;
            }
            return outstack.m_41613_() + result.m_41613_() <= outstack.m_41741_();
        }
        return false;
    }

    private int getAlloyTime(ItemStack input1, ItemStack input2, ItemStack catalyst) {
        Optional<IFusionRecipe> maybeRecipe = this.getRecipe(input1, input2, catalyst);
        if (maybeRecipe.isPresent()) {
            return ((FusionRecipe)maybeRecipe.get()).getCookTime();
        }
        return DEFAULT_ALLOY_TIME;
    }

    protected void smelt(ItemStack result) {
        if (!result.m_41619_() && this.canSmelt(result)) {
            ItemStack input1 = this.inventory.getStackInSlot(0).m_41777_();
            ItemStack input2 = this.inventory.getStackInSlot(1).m_41777_();
            ItemStack catalyst = this.inventory.getStackInSlot(2).m_41777_();
            ItemStack outstack = this.inventory.getStackInSlot(3).m_41777_();
            if (outstack.m_41619_()) {
                this.inventory.setStackInSlot(3, result.m_41777_());
            } else if (outstack.m_41720_() == result.m_41720_()) {
                outstack.m_41769_(result.m_41613_());
                this.inventory.setStackInSlot(3, outstack);
            }
            if (!this.f_58857_.f_46443_) {
                this.setRecipeUsed(this.getRecipe(input1, input2, catalyst).orElse(null));
            }
            if (input1.hasCraftingRemainingItem()) {
                this.inventory.setStackInSlot(0, input1.getCraftingRemainingItem());
            } else {
                input1.m_41774_(1);
                this.inventory.setStackInSlot(0, input1);
            }
            if (input2.hasCraftingRemainingItem()) {
                this.inventory.setStackInSlot(1, input2.getCraftingRemainingItem());
            } else {
                input2.m_41774_(1);
                this.inventory.setStackInSlot(1, input2);
            }
            if (catalyst.hasCraftingRemainingItem()) {
                this.inventory.setStackInSlot(2, catalyst.getCraftingRemainingItem());
            } else {
                catalyst.m_41774_(1);
                this.inventory.setStackInSlot(2, catalyst);
            }
        }
    }

    public static void serverTick(Level level, BlockPos blockpos, BlockState blockstate, AbstractAlloyFurnaceTileEntity tile) {
        boolean hasFuel = tile.isBurning();
        boolean flag1 = false;
        if (tile.isBurning()) {
            --tile.fuelBurnTimeLeft;
        }
        if (!level.f_46443_) {
            ItemStack input1 = tile.inventory.getStackInSlot(0).m_41777_();
            ItemStack input2 = tile.inventory.getStackInSlot(1).m_41777_();
            ItemStack catalyst = tile.inventory.getStackInSlot(2).m_41777_();
            ItemStack fuel = tile.inventory.getStackInSlot(4).m_41777_();
            ItemStack result = tile.getResult(input1, input2, catalyst).orElse(ItemStack.f_41583_);
            if (!(!tile.isBurning() && fuel.m_41619_() || input1.m_41619_() || input2.m_41619_() || catalyst.m_41619_())) {
                if (!tile.isBurning() && tile.canSmelt(result)) {
                    tile.maxFuelBurnTime = tile.fuelBurnTimeLeft = tile.getBurnDuration(fuel);
                    if (tile.isBurning()) {
                        flag1 = true;
                        if (fuel.hasCraftingRemainingItem()) {
                            tile.inventory.setStackInSlot(4, fuel.getCraftingRemainingItem());
                        } else if (!fuel.m_41619_()) {
                            fuel.m_41774_(1);
                            tile.inventory.setStackInSlot(4, fuel);
                        }
                    }
                }
                if (tile.isBurning() && tile.canSmelt(result)) {
                    if (tile.smeltTimeProgress <= 0) {
                        tile.maxSmeltTime = tile.getAlloyTime(input1, input2, catalyst);
                        tile.smeltTimeProgress = 0;
                    }
                    ++tile.smeltTimeProgress;
                    if (tile.smeltTimeProgress >= tile.maxSmeltTime) {
                        tile.smelt(result);
                        tile.smeltTimeProgress = 0;
                        tile.maxSmeltTime = !tile.inventory.getStackInSlot(0).m_41619_() && !tile.inventory.getStackInSlot(1).m_41619_() && !tile.inventory.getStackInSlot(2).m_41619_() ? tile.getAlloyTime(tile.inventory.getStackInSlot(0), tile.inventory.getStackInSlot(1), tile.inventory.getStackInSlot(2)) : 0;
                        flag1 = true;
                    }
                } else {
                    tile.smeltTimeProgress = 0;
                }
            } else if (!tile.isBurning() && tile.smeltTimeProgress > 0) {
                tile.smeltTimeProgress = (short)Mth.m_14045_((int)(tile.smeltTimeProgress - 2), (int)0, (int)tile.maxSmeltTime);
            }
            if (hasFuel != tile.isBurning()) {
                flag1 = true;
                BlockState newState = (BlockState)tile.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(tile.isBurning()));
                level.m_7731_(blockpos, newState, 3);
            }
        }
        if (flag1) {
            tile.m_6596_();
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_(INVENTORY_TAG));
        this.smeltTimeProgress = compound.m_128451_(SMELT_TIME_LEFT_TAG);
        this.maxSmeltTime = compound.m_128451_(MAX_SMELT_TIME_TAG);
        this.fuelBurnTimeLeft = compound.m_128451_(FUEL_BURN_TIME_LEFT_TAG);
        this.maxFuelBurnTime = compound.m_128451_(MAX_FUEL_BURN_TIME_TAG);
        if (this.m_58898_() && !this.f_58857_.f_46443_) {
            this.lastBurning = this.isBurning();
        }
        int ii = compound.m_128448_("RecipesUsedSize");
        for (int jj = 0; jj < ii; ++jj) {
            ResourceLocation resourcelocation = new ResourceLocation(compound.m_128461_("RecipeLocation" + jj));
            int kk = compound.m_128451_("RecipeAmount" + jj);
            this.recipe2xp_map.put(resourcelocation, kk);
        }
        if (this.m_58898_()) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)AbstractAlloyFurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning())));
        }
    }

    @Nonnull
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
        compound.m_128405_(SMELT_TIME_LEFT_TAG, this.smeltTimeProgress);
        compound.m_128405_(MAX_SMELT_TIME_TAG, this.maxSmeltTime);
        compound.m_128405_(FUEL_BURN_TIME_LEFT_TAG, this.fuelBurnTimeLeft);
        compound.m_128405_(MAX_FUEL_BURN_TIME_TAG, this.maxFuelBurnTime);
        compound.m_128376_("RecipesUsedSize", (short)this.recipe2xp_map.size());
        int ii = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipe2xp_map.entrySet()) {
            compound.m_128359_("RecipeLocation" + ii, entry.getKey().toString());
            compound.m_128405_("RecipeAmount" + ii, entry.getValue().intValue());
            ++ii;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbtTag = pkt.m_131708_();
        this.m_142466_(nbtTag);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void grantExperience(Player player) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipe2xp_map.entrySet()) {
            player.m_9236_().m_7465_().m_44043_(entry.getKey()).ifPresent(p_213993_3_ -> {
                list.add(p_213993_3_);
                AbstractAlloyFurnaceTileEntity.spawnExpOrbs(player, (Integer)entry.getValue(), ((FusionRecipe)p_213993_3_).getExperience());
            });
        }
        player.m_7281_((Collection)list);
        this.recipe2xp_map.clear();
    }

    private static void spawnExpOrbs(Player player, int pCount, float experience) {
        if (experience == 0.0f) {
            pCount = 0;
        } else if (experience < 1.0f) {
            int i = Mth.m_14143_((float)((float)pCount * experience));
            if (i < Mth.m_14167_((float)((float)pCount * experience)) && Math.random() < (double)((float)pCount * experience - (float)i)) {
                ++i;
            }
            pCount = i;
        }
        while (pCount > 0) {
            int j = ExperienceOrb.m_20782_((int)pCount);
            pCount -= j;
            player.m_9236_().m_7967_((Entity)new ExperienceOrb(player.m_9236_(), player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, j));
        }
    }

    public class AlloyFurnaceHandler
    extends SidedWrapper {
        public AlloyFurnaceHandler(IItemHandlerModifiable inventory, Direction side) {
            super(inventory, side);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot == 3) {
                return stack;
            }
            if (slot == 2 && this.side == Direction.UP) {
                return super.insertItem(slot, stack, simulate);
            }
            if (slot == 4 && (this.side == Direction.NORTH || this.side == Direction.SOUTH)) {
                return super.insertItem(slot, stack, simulate);
            }
            if (slot == 0 && this.side == Direction.EAST || slot == 1 && this.side == Direction.WEST) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if ((slot == 4 || slot == 2) && this.side == Direction.DOWN) {
                ItemStack pstack = this.getStackInSlot(slot);
                if (pstack.m_150930_(Items.f_42446_)) {
                    return super.extractItem(slot, amount, simulate);
                }
                return ItemStack.f_41583_;
            }
            if (slot == 3 && this.side == Direction.DOWN) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }
    }
}

