/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.fusion;

import javax.annotation.Nonnull;
import mod.alexndr.fusion.Fusion;
import mod.alexndr.fusion.config.ConfigHelper;
import mod.alexndr.fusion.config.ConfigHolder;
import mod.alexndr.fusion.config.FusionConfig;
import mod.alexndr.fusion.init.ModBlocks;
import mod.alexndr.simplecorelib.api.config.FlagCondition;
import mod.alexndr.simplecorelib.api.config.ISimpleConfig;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="fusion", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger((String)"fusion Mod Event Subscriber");

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        Fusion.isSimpleOresLoaded = ModList.get().isLoaded("simpleores");
        LOGGER.info("Simple Ores is" + (Fusion.isSimpleOresLoaded ? " " : " not ") + "loaded.");
        LOGGER.debug("Common setup done");
    }

    @SubscribeEvent
    public static void onRegisterItems(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.f_256913_) {
            ModBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
                BlockItem blockItem = new BlockItem(block, new Item.Properties());
                event.register(Registries.f_256913_, helper -> helper.register(ForgeRegistries.BLOCKS.getKey(block), (Object)blockItem));
            });
            LOGGER.debug("Registered BlockItems");
        }
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigHolder.SERVER_SPEC) {
            ConfigHelper.bakeServer(config);
        }
        if (config.getSpec() == ConfigHolder.CLIENT_SPEC) {
            ConfigHelper.bakeClient(config);
        }
    }

    @SubscribeEvent
    public static void onRegisterRecipeSerializers(@Nonnull RegisterEvent event) {
        if (event.getRegistryKey() == Registries.f_256764_) {
            CraftingHelper.register((IConditionSerializer)new FlagCondition.Serializer((ISimpleConfig)FusionConfig.INSTANCE, new ResourceLocation("fusion", "flag")));
        }
    }
}

