/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.network.EnderStorageNetwork;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Cuboid6;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileFrequencyOwner
extends BlockEntity {
    public static final Cuboid6 SELECTION_BUTTON = new Cuboid6(-0.0625, 0.0, -0.125, 0.0625, 0.0625, 0.125);
    protected Frequency frequency = new Frequency();
    private int changeCount;

    public TileFrequencyOwner(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public void setFreq(Frequency frequency) {
        this.frequency = frequency;
        this.onFrequencySet();
        this.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        if (!this.f_58857_.f_46443_) {
            this.sendUpdatePacket();
        }
    }

    public void tick() {
        if (this.getStorage().getChangeCount() > this.changeCount) {
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            this.changeCount = this.getStorage().getChangeCount();
        }
    }

    public abstract AbstractEnderStorage getStorage();

    public void onFrequencySet() {
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.frequency.set(new Frequency(tag.m_128469_("Frequency")));
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("Frequency", (Tag)this.frequency.writeToNBT(new CompoundTag()));
    }

    public void m_142339_(Level p_155231_) {
        super.m_142339_(p_155231_);
        this.onFrequencySet();
    }

    public boolean activate(Player player, int subHit, InteractionHand hand) {
        return false;
    }

    public void onNeighborChange(BlockPos from) {
    }

    public void onPlaced(LivingEntity entity) {
    }

    protected void sendUpdatePacket() {
        this.createPacket().sendToChunk(this.f_58857_, this.m_58899_().m_123341_() >> 4, this.m_58899_().m_123343_() >> 4);
    }

    public PacketCustom createPacket() {
        PacketCustom packet = new PacketCustom(EnderStorageNetwork.NET_CHANNEL, 1);
        packet.writePos(this.m_58899_());
        this.writeToPacket((MCDataOutput)packet);
        return packet;
    }

    public void writeToPacket(MCDataOutput packet) {
        this.frequency.writeToPacket(packet);
    }

    public void readFromPacket(MCDataInput packet) {
        this.frequency.set(Frequency.readFromPacket(packet));
        this.onFrequencySet();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public int getLightValue() {
        return 0;
    }

    public boolean redstoneInteraction() {
        return false;
    }

    public int comparatorInput() {
        return 0;
    }

    public boolean rotate() {
        return false;
    }
}

