/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.FluidStackLoadable;
import slimeknights.mantle.data.loadable.common.NBTLoadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.TagPreference;
import slimeknights.mantle.util.typed.TypedMap;

public abstract class FluidOutput
implements Supplier<FluidStack> {
    public static final FluidOutput EMPTY = new OfStack(FluidStack.EMPTY);

    @Override
    public abstract FluidStack get();

    public final FluidStack copy() {
        return this.get().copy();
    }

    public abstract int getAmount();

    public boolean isEmpty() {
        return this.getAmount() <= 0;
    }

    @Deprecated(forRemoval=true)
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        this.serialize(json);
        return json;
    }

    public abstract void serialize(JsonObject var1);

    public static FluidOutput fromStack(FluidStack stack) {
        if (stack.isEmpty()) {
            return EMPTY;
        }
        return new OfStack(stack);
    }

    public static FluidOutput fromFluid(Fluid fluid, int amount) {
        return new OfFluid(fluid, amount);
    }

    public static FluidOutput fromTag(TagKey<Fluid> tag, int amount, @Nullable CompoundTag nbt) {
        return new OfTagPreference(tag, amount, nbt);
    }

    public static FluidOutput fromTag(TagKey<Fluid> tag, int amount) {
        return FluidOutput.fromTag(tag, amount, null);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeFluidStack(this.get());
    }

    public static FluidOutput read(FriendlyByteBuf buffer) {
        return FluidOutput.fromStack(buffer.readFluidStack());
    }

    private static class OfStack
    extends FluidOutput {
        private final FluidStack stack;

        @Override
        public FluidStack get() {
            return this.stack;
        }

        @Override
        public int getAmount() {
            return this.stack.getAmount();
        }

        @Override
        public void serialize(JsonObject json) {
            FluidStackLoadable.OPTIONAL_STACK_NBT.serialize(this.stack, json);
        }

        public OfStack(FluidStack stack) {
            this.stack = stack;
        }
    }

    private static class OfFluid
    extends FluidOutput {
        private final Fluid fluid;
        private final int amount;
        private FluidStack cachedStack;

        @Override
        public FluidStack get() {
            if (this.cachedStack == null) {
                this.cachedStack = new FluidStack(this.fluid, this.amount);
            }
            return this.cachedStack;
        }

        @Override
        public void serialize(JsonObject json) {
            if (this.amount > 0) {
                json.add("fluid", Loadables.FLUID.serialize(this.fluid));
            }
            json.addProperty("amount", (Number)this.amount);
        }

        public OfFluid(Fluid fluid, int amount) {
            this.fluid = fluid;
            this.amount = amount;
        }

        @Override
        public int getAmount() {
            return this.amount;
        }
    }

    private static class OfTagPreference
    extends FluidOutput {
        private final TagKey<Fluid> tag;
        private final int amount;
        @Nullable
        private final CompoundTag nbt;
        private FluidStack cachedResult = null;

        @Override
        public FluidStack get() {
            if (this.cachedResult == null) {
                Optional<Fluid> preference = TagPreference.getPreference(this.tag);
                if (preference.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                this.cachedResult = new FluidStack(preference.orElseThrow(), this.amount, this.nbt);
            }
            return this.cachedResult;
        }

        @Override
        public void serialize(JsonObject json) {
            if (this.amount > 0) {
                json.addProperty("tag", this.tag.f_203868_().toString());
            }
            json.addProperty("amount", (Number)this.amount);
            if (this.amount > 0 && this.nbt != null) {
                json.add("nbt", (JsonElement)NBTLoadable.ALLOW_STRING.serialize(this.nbt));
            }
        }

        public OfTagPreference(TagKey<Fluid> tag, int amount, @Nullable CompoundTag nbt) {
            this.tag = tag;
            this.amount = amount;
            this.nbt = nbt;
        }

        @Override
        public int getAmount() {
            return this.amount;
        }
    }

    public static enum Loadable implements RecordLoadable<FluidOutput>
    {
        OPTIONAL(false),
        REQUIRED(true);

        private final boolean nonEmpty;
        private final RecordLoadable<FluidStack> stack;

        private Loadable(boolean nonEmpty) {
            this.nonEmpty = nonEmpty;
            this.stack = nonEmpty ? FluidStackLoadable.REQUIRED_STACK_NBT : FluidStackLoadable.OPTIONAL_STACK_NBT;
        }

        @Override
        public FluidOutput deserialize(JsonObject json, TypedMap context) {
            if (json.has("tag")) {
                return FluidOutput.fromTag((TagKey<Fluid>)((TagKey)Loadables.FLUID_TAG.getIfPresent(json, "tag", context)), (Integer)IntLoadable.FROM_ONE.getIfPresent(json, "amount", context), NBTLoadable.ALLOW_STRING.getOrDefault(json, "nbt", null));
            }
            return FluidOutput.fromStack(this.stack.deserialize(json, context));
        }

        @Override
        public void serialize(FluidOutput output, JsonObject json) {
            if (this.nonEmpty && output.isEmpty()) {
                throw new IllegalArgumentException("ItemOutput cannot be empty for this recipe");
            }
            output.serialize(json);
        }

        @Override
        public FluidOutput decode(FriendlyByteBuf buffer, TypedMap context) {
            return FluidOutput.fromStack((FluidStack)this.stack.decode(buffer, context));
        }

        @Override
        public void encode(FriendlyByteBuf buffer, FluidOutput object) {
            this.stack.encode(buffer, object.get());
        }

        public FluidOutput getOrEmpty(JsonObject parent, String key) {
            return this.getOrDefault(parent, key, EMPTY);
        }

        public <P> LoadableField<FluidOutput, P> emptyField(String key, boolean serializeDefault, Function<P, FluidOutput> getter) {
            return this.defaultField(key, EMPTY, serializeDefault, getter);
        }

        public <P> LoadableField<FluidOutput, P> emptyField(String key, Function<P, FluidOutput> getter) {
            return this.emptyField(key, false, getter);
        }
    }
}

