/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.IAmLoadable;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Streamable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public class EitherLoadable {
    private EitherLoadable() {
    }

    public static <T extends IAmLoadable> TypedBuilder<T> typed() {
        return new TypedBuilder();
    }

    public static <T extends IAmLoadable.Record> RecordBuilder<T> record() {
        return new RecordBuilder();
    }

    public static class TypedBuilder<T extends IAmLoadable> {
        private Loadable<? extends T> array = null;
        private Loadable<? extends T> primitive = null;
        private final List<KeyOption<T>> keys = new ArrayList<KeyOption<T>>();

        private TypedBuilder() {
        }

        public TypedBuilder<T> key(String key, RecordLoadable<? extends T> loadable) {
            this.keys.add(new KeyOption<T>(key, loadable));
            return this;
        }

        public TypedBuilder<T> array(Loadable<? extends T> loadable) {
            if (this.array != null) {
                throw new IllegalStateException("Duplicate array loadable, previous value " + this.array);
            }
            this.array = loadable;
            return this;
        }

        public TypedBuilder<T> primitive(Loadable<? extends T> loadable) {
            if (this.primitive != null) {
                throw new IllegalStateException("Duplicate primitive loadable, previous value " + this.primitive);
            }
            this.primitive = loadable;
            return this;
        }

        private List<KeyOption<T>> getKeys() {
            List<KeyOption<T>> keys = List.copyOf(this.keys);
            int size = keys.size() + (this.array != null ? 1 : 0) + (this.primitive != null ? 1 : 0);
            if (size < 2) {
                throw new IllegalStateException("EitherLoadable must have at least 2 options.");
            }
            return keys;
        }

        public Loadable<T> build(Loadable<T> network) {
            return new Typing<T>(List.of(network), this.getKeys(), this.array, this.primitive);
        }

        public Loadable<T> build() {
            List<KeyOption<KeyOption>> keys = this.getKeys();
            ArrayList builder = new ArrayList(keys.size() + 2);
            keys.forEach(key -> builder.add(key.loadable));
            if (this.array != null) {
                builder.add(this.array);
            }
            if (this.primitive != null) {
                builder.add(this.primitive);
            }
            return new Typing<T>(List.copyOf(builder), keys, this.array, this.primitive);
        }
    }

    public static class RecordBuilder<T extends IAmLoadable.Record> {
        private final List<KeyOption<T>> keys = new ArrayList<KeyOption<T>>();

        private RecordBuilder() {
        }

        public RecordBuilder<T> key(String key, RecordLoadable<? extends T> loadable) {
            this.keys.add(new KeyOption<T>(key, loadable));
            return this;
        }

        private List<KeyOption<T>> getKeys() {
            List<KeyOption<T>> keys = List.copyOf(this.keys);
            if (keys.size() < 2) {
                throw new IllegalStateException("EitherLoadable must have at least 2 options.");
            }
            return keys;
        }

        public RecordLoadable<T> build(Loadable<T> network) {
            return new Record<T>(List.of(network), this.getKeys());
        }

        public RecordLoadable<T> build() {
            List<KeyOption<T>> keys = this.getKeys();
            List network = keys.stream().map(option -> option.loadable).toList();
            return new Record(network, keys);
        }
    }

    private record Record<T extends IAmLoadable.Record>(List<Loadable<T>> network, List<KeyOption<T>> keys) implements RecordLoadable<T>,
    EitherImpl<T>
    {
        @Override
        public T deserialize(JsonObject json, TypedMap context) {
            return (T)((IAmLoadable.Record)this.deserializeObject((JsonElement)json, context, "[root]"));
        }

        @Override
        public void serialize(T object, JsonObject json) {
            object.loadable().serialize(object, json);
        }

        @Override
        public T decode(FriendlyByteBuf buffer, TypedMap context) {
            return (T)((IAmLoadable.Record)this.loadableFromNetwork(buffer).decode(buffer, context));
        }

        @Override
        public void encode(FriendlyByteBuf buffer, T object) {
            EitherImpl.super.encode(buffer, object);
        }
    }

    private record Typing<T extends IAmLoadable>(List<Loadable<T>> network, List<KeyOption<T>> keys, @Nullable Loadable<? extends T> array, @Nullable Loadable<? extends T> primitive) implements EitherImpl<T>
    {
        @Override
        public T convert(JsonElement element, String key, TypedMap context) {
            if (this.array != null && element.isJsonArray()) {
                return (T)((IAmLoadable)this.array.convert(element, key, context));
            }
            if (this.primitive != null && element.isJsonPrimitive()) {
                return (T)((IAmLoadable)this.primitive.convert(element, key, context));
            }
            if (!this.keys.isEmpty()) {
                return this.deserializeObject(element, context, key);
            }
            throw new JsonSyntaxException("JSON at " + key + " must be one of: array, primitive");
        }

        @Override
        public JsonElement serialize(T object) {
            return object.loadable().serialize((IAmLoadable)object);
        }

        @Override
        public T decode(FriendlyByteBuf buffer, TypedMap context) {
            return (T)((IAmLoadable)this.loadableFromNetwork(buffer).decode(buffer, context));
        }
    }

    private static interface EitherImpl<T extends IAmLoadable>
    extends Loadable<T> {
        public List<? extends Streamable<T>> network();

        public List<KeyOption<T>> keys();

        @Nullable
        default public Loadable<? extends T> array() {
            return null;
        }

        @Nullable
        default public Loadable<? extends T> primitive() {
            return null;
        }

        default public T deserializeObject(JsonElement element, TypedMap context, String key) {
            List<KeyOption<T>> keys = this.keys();
            if (element.isJsonObject()) {
                JsonObject json = element.getAsJsonObject();
                for (KeyOption<T> option : keys) {
                    if (!json.has(option.key)) continue;
                    return (T)((IAmLoadable)option.loadable.deserialize(json, context));
                }
            }
            StringBuilder builder = new StringBuilder();
            builder.append("JSON at ").append(key).append(" must be one of: ");
            if (this.array() != null) {
                builder.append("array, ");
            }
            if (this.primitive() != null) {
                builder.append("primitive, ");
            }
            builder.append("object with key from [").append(keys.stream().map(KeyOption::key).collect(Collectors.joining(", "))).append(']');
            throw new JsonSyntaxException(builder.toString());
        }

        default public Streamable<T> loadableFromNetwork(FriendlyByteBuf buffer) {
            List<Streamable<T>> networks = this.network();
            int size = networks.size();
            if (size == 1) {
                return networks.get(0);
            }
            int networkIndex = buffer.m_130242_();
            if (networkIndex < size) {
                return networks.get(networkIndex);
            }
            throw new DecoderException("Unknown network index " + networkIndex + " for EitherLoadable with network size " + size + ", this should not be possible.");
        }

        @Override
        default public void encode(FriendlyByteBuf buffer, T object) {
            List<Streamable<T>> networks = this.network();
            if (networks.size() != 1) {
                Loadable<? extends IAmLoadable> objectLoadable = object.loadable();
                for (int i = 0; i < networks.size(); ++i) {
                    Streamable<T> network = networks.get(i);
                    if (network != objectLoadable) continue;
                    buffer.m_130130_(i);
                    network.encode(buffer, object);
                    return;
                }
                throw new IllegalArgumentException("Unable to serialize " + object + " to network as its loadable " + objectLoadable + " is not allows in the EitherLoadable");
            }
            networks.get(0).encode(buffer, object);
        }
    }

    private record KeyOption<T>(String key, RecordLoadable<? extends T> loadable) {
    }
}

