/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.builder;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.Mantle;

public class NBTKeyModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private String key = null;
    private ResourceLocation extraTexturesKey = null;

    public NBTKeyModelBuilder(ResourceLocation loaderId, T parent, ExistingFileHelper existingFileHelper) {
        super(Mantle.getResource("nbt_key"), parent, existingFileHelper);
    }

    public JsonObject toJson(JsonObject json) {
        if (this.key == null) {
            throw new IllegalStateException("Must set key to use NBTKeyModel");
        }
        json = super.toJson(json);
        json.addProperty("nbt_key", this.key);
        if (this.extraTexturesKey != null) {
            json.addProperty("extra_textures_key", this.extraTexturesKey.toString());
        }
        return json;
    }

    public NBTKeyModelBuilder<T> key(String key) {
        this.key = key;
        return this;
    }

    public NBTKeyModelBuilder<T> extraTexturesKey(ResourceLocation extraTexturesKey) {
        this.extraTexturesKey = extraTexturesKey;
        return this;
    }
}

