/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.FaceRedstonePart;
import codechicken.multipart.minecraft.McSidedStatePart;
import codechicken.multipart.minecraft.MinecraftMultipartModContent;
import codechicken.multipart.util.PartRayTraceResult;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class ButtonPart
extends McSidedStatePart
implements FaceRedstonePart {
    private final MultipartType<?> type;
    private final ButtonBlock block;

    public ButtonPart(MultipartType<?> type, ButtonBlock block) {
        this(type, block, block.m_49966_());
    }

    public ButtonPart(MultipartType<?> type, ButtonBlock block, BlockState state) {
        super((BlockState)state.m_61124_((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)));
        this.type = type;
        this.block = block;
    }

    @Override
    public MultipartType<?> getType() {
        return this.type;
    }

    @Override
    public BlockState defaultBlockState() {
        return this.block.m_49966_();
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((ItemLike)this.block);
    }

    @Override
    public Direction getSide() {
        return FaceAttachedHorizontalDirectionalBlock.m_53200_((BlockState)this.state).m_122424_();
    }

    @Override
    @Nullable
    public MultiPart setStateOnPlacement(BlockPlaceContext context) {
        BlockState state;
        Direction face = context.m_43719_();
        switch (face) {
            case DOWN: {
                BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().m_61124_((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.CEILING)).m_61124_((Property)ButtonBlock.f_54117_, (Comparable)context.m_8125_());
                break;
            }
            case UP: {
                BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().m_61124_((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)ButtonBlock.f_54117_, (Comparable)context.m_8125_());
                break;
            }
            default: {
                BlockState blockState = state = (BlockState)((BlockState)this.defaultBlockState().m_61124_((Property)ButtonBlock.f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)ButtonBlock.f_54117_, (Comparable)face);
            }
        }
        if (state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
            this.state = state;
            return this;
        }
        return null;
    }

    public int delay() {
        return this.block.f_244105_;
    }

    public boolean canArrowsPress() {
        return this.block.f_243959_;
    }

    @Override
    public InteractionResult activate(Player player, PartRayTraceResult hit, ItemStack item, InteractionHand hand) {
        if (this.pressed()) {
            return InteractionResult.CONSUME;
        }
        if (!this.level().f_46443_) {
            this.toggle();
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void scheduledTick() {
        if (this.pressed()) {
            this.updateState();
        }
    }

    public boolean pressed() {
        return (Boolean)this.state.m_61143_((Property)ButtonBlock.f_51045_);
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (!this.pressed() && !this.level().f_46443_ && entity instanceof Arrow) {
            this.updateState();
        }
    }

    private void toggle() {
        this.state = (BlockState)this.state.m_61122_((Property)ButtonBlock.f_51045_);
        boolean on = this.pressed();
        this.block.m_51067_(null, (LevelAccessor)this.level(), this.pos(), on);
        if (on) {
            this.scheduleTick(this.delay());
        }
        this.sendUpdate(this::writeDesc);
        this.tile().m_6596_();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(this.getSide().ordinal());
    }

    private void updateState() {
        boolean pressed;
        boolean arrows = this.canArrowsPress() && !this.level().m_45976_(Arrow.class, this.getShape(CollisionContext.m_82749_()).m_83215_().m_82338_(this.pos())).isEmpty();
        if (arrows != (pressed = this.pressed())) {
            this.toggle();
        }
        if (arrows && pressed) {
            this.scheduleTick(this.delay());
        }
    }

    @Override
    public void onRemoved() {
        if (this.pressed()) {
            this.tile().notifyNeighborChange(this.getSide().ordinal());
        }
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.pressed() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.pressed() && side == this.getSide().ordinal() ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return this.getSide().ordinal();
    }

    public static class WarpedButtonPart
    extends ButtonPart {
        public WarpedButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.WARPED_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50670_);
        }

        public WarpedButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.WARPED_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50670_, state);
        }
    }

    public static class CrimsonButtonPart
    extends ButtonPart {
        public CrimsonButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.CRIMSON_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50669_);
        }

        public CrimsonButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.CRIMSON_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50669_, state);
        }
    }

    public static class DarkOakButtonPart
    extends ButtonPart {
        public DarkOakButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.DARK_OAK_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50309_);
        }

        public DarkOakButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.DARK_OAK_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50309_, state);
        }
    }

    public static class AcaciaButtonPart
    extends ButtonPart {
        public AcaciaButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.ACACIA_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50308_);
        }

        public AcaciaButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.ACACIA_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50308_, state);
        }
    }

    public static class JungleButtonPart
    extends ButtonPart {
        public JungleButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.JUNGLE_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50254_);
        }

        public JungleButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.JUNGLE_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50254_, state);
        }
    }

    public static class BirchButtonPart
    extends ButtonPart {
        public BirchButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.BIRCH_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50253_);
        }

        public BirchButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.BIRCH_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50253_, state);
        }
    }

    public static class SpruceButtonPart
    extends ButtonPart {
        public SpruceButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.SPRUCE_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50252_);
        }

        public SpruceButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.SPRUCE_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50252_, state);
        }
    }

    public static class OakButtonPart
    extends ButtonPart {
        public OakButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.OAK_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50251_);
        }

        public OakButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.OAK_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50251_, state);
        }
    }

    public static class PolishedBlackstoneButtonPart
    extends ButtonPart {
        public PolishedBlackstoneButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.POLISHED_BLACKSTONE_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50710_);
        }

        public PolishedBlackstoneButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.POLISHED_BLACKSTONE_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50710_, state);
        }
    }

    public static class StoneButtonPart
    extends ButtonPart {
        public StoneButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.STONE_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50124_);
        }

        public StoneButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.STONE_BUTTON_PART.get(), (ButtonBlock)Blocks.f_50124_, state);
        }
    }
}

