/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.init;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.exploration.ProjectRedExploration;
import mrtjp.projectred.exploration.init.ExplorationBlocks;
import mrtjp.projectred.exploration.world.gen.ConfigFileControlledAddCarversBiomeModifier;
import mrtjp.projectred.exploration.world.gen.ConfigFileControlledAddFeaturesBiomeModifier;
import mrtjp.projectred.exploration.world.gen.MarbleCaveWorldCarver;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ExplorationWorldFeatures {
    public static final String ID_MARBLE_CAVE_CARVER = "marble_cave";
    public static RegistryObject<WorldCarver<CaveCarverConfiguration>> MARBLE_CAVE_CARVER;
    public static RegistryObject<Codec<ConfigFileControlledAddCarversBiomeModifier>> ADD_CARVER_BIOME_MODIFIER_CODEC;
    public static RegistryObject<Codec<ConfigFileControlledAddFeaturesBiomeModifier>> ADD_FEATURES_BIOME_MODIFIER_CODEC;
    public static ResourceKey<ConfiguredWorldCarver<?>> MARBLE_CAVE_CONFIGURED_CARVER;
    public static ResourceKey<ConfiguredFeature<?, ?>> RUBY_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<ConfiguredFeature<?, ?>> SAPPHIRE_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<ConfiguredFeature<?, ?>> PERIDOT_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<ConfiguredFeature<?, ?>> ELECTROTINE_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<ConfiguredFeature<?, ?>> TIN_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<PlacedFeature> RUBY_ORE_PLACED_FEATURE;
    public static ResourceKey<PlacedFeature> SAPPHIRE_ORE_PLACED_FEATURE;
    public static ResourceKey<PlacedFeature> PERIDOT_ORE_PLACED_FEATURE;
    public static ResourceKey<PlacedFeature> ELECTROTINE_ORE_PLACED_FEATURE;
    public static ResourceKey<PlacedFeature> TIN_ORE_PLACED_FEATURE;
    public static ResourceKey<PlacedFeature> SILVER_ORE_PLACED_FEATURE;

    public static void register() {
        MARBLE_CAVE_CARVER = ProjectRedExploration.WORLD_CARVERS.register(ID_MARBLE_CAVE_CARVER, () -> new MarbleCaveWorldCarver((Codec<CaveCarverConfiguration>)CaveCarverConfiguration.f_159154_));
        ADD_CARVER_BIOME_MODIFIER_CODEC = ProjectRedExploration.BIOME_MODIFIER_SERIALIZERS.register("add_carver", ConfigFileControlledAddCarversBiomeModifier::createCodec);
        ADD_FEATURES_BIOME_MODIFIER_CODEC = ProjectRedExploration.BIOME_MODIFIER_SERIALIZERS.register("add_features", ConfigFileControlledAddFeaturesBiomeModifier::createCodec);
    }

    public static ResourceKey<ConfiguredWorldCarver<?>> createCarverKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257003_, (ResourceLocation)new ResourceLocation("projectred_exploration", name));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createFeatureKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("projectred_exploration", name));
    }

    public static ResourceKey<PlacedFeature> createPlacedFeatureKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("projectred_exploration", name));
    }

    public static ResourceKey<BiomeModifier> createBiomeModifierKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("projectred_exploration", name));
    }

    public static void bootstrapCarvers(BootstapContext<ConfiguredWorldCarver<?>> context) {
        HolderGetter blockGetter = context.m_255420_(Registries.f_256747_);
        context.m_255272_(MARBLE_CAVE_CONFIGURED_CARVER, (Object)((WorldCarver)MARBLE_CAVE_CARVER.get()).m_65063_((CarverConfiguration)new CaveCarverConfiguration(0.01f, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158922_((int)180)), (FloatProvider)UniformFloat.m_146605_((float)0.1f, (float)0.9f), VerticalAnchor.m_158930_((int)8), CarverDebugSettings.m_159136_((boolean)false, (BlockState)Blocks.f_50669_.m_49966_()), (HolderSet)blockGetter.m_254956_(BlockTags.f_215820_), (FloatProvider)UniformFloat.m_146605_((float)0.7f, (float)1.4f), (FloatProvider)UniformFloat.m_146605_((float)0.8f, (float)1.3f), (FloatProvider)UniformFloat.m_146605_((float)-1.0f, (float)-0.4f))));
    }

    public static void bootstrapFeatures(BootstapContext<ConfiguredFeature<?, ?>> context) {
        ExplorationWorldFeatures.registerOreConfiguration(context, RUBY_ORE_CONFIGURED_FEATURE, ExplorationBlocks.RUBY_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_RUBY_ORE_BLOCK, 8);
        ExplorationWorldFeatures.registerOreConfiguration(context, SAPPHIRE_ORE_CONFIGURED_FEATURE, ExplorationBlocks.SAPPHIRE_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_SAPPHIRE_ORE_BLOCK, 8);
        ExplorationWorldFeatures.registerOreConfiguration(context, PERIDOT_ORE_CONFIGURED_FEATURE, ExplorationBlocks.PERIDOT_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_PERIDOT_ORE_BLOCK, 10);
        ExplorationWorldFeatures.registerOreConfiguration(context, ELECTROTINE_ORE_CONFIGURED_FEATURE, ExplorationBlocks.ELECTROTINE_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_ELECTROTINE_ORE_BLOCK, 8);
        ExplorationWorldFeatures.registerOreConfiguration(context, TIN_ORE_CONFIGURED_FEATURE, ExplorationBlocks.TIN_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_TIN_ORE_BLOCK, 8);
        ExplorationWorldFeatures.registerOreConfiguration(context, SILVER_ORE_CONFIGURED_FEATURE, ExplorationBlocks.SILVER_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_SILVER_ORE_BLOCK, 9);
    }

    public static void bootstrapPlacements(BootstapContext<PlacedFeature> context) {
        HolderGetter features = context.m_255420_(Registries.f_256911_);
        ExplorationWorldFeatures.registerOrePlacement(context, RUBY_ORE_PLACED_FEATURE, features.m_255043_(RUBY_ORE_CONFIGURED_FEATURE), -80, 80, 1);
        ExplorationWorldFeatures.registerOrePlacement(context, SAPPHIRE_ORE_PLACED_FEATURE, features.m_255043_(SAPPHIRE_ORE_CONFIGURED_FEATURE), -80, 80, 1);
        ExplorationWorldFeatures.registerOrePlacement(context, PERIDOT_ORE_PLACED_FEATURE, features.m_255043_(PERIDOT_ORE_CONFIGURED_FEATURE), -80, 80, 1);
        ExplorationWorldFeatures.registerOrePlacement(context, ELECTROTINE_ORE_PLACED_FEATURE, features.m_255043_(ELECTROTINE_ORE_CONFIGURED_FEATURE), -32, 32, 4);
        ExplorationWorldFeatures.registerOrePlacement(context, TIN_ORE_PLACED_FEATURE, features.m_255043_(TIN_ORE_CONFIGURED_FEATURE), -24, 56, 8);
        ExplorationWorldFeatures.registerOrePlacement(context, SILVER_ORE_PLACED_FEATURE, features.m_255043_(SILVER_ORE_CONFIGURED_FEATURE), -64, 32, 6);
    }

    public static void bootstrapBiomeModifiers(BootstapContext<BiomeModifier> context) {
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        HolderGetter worldCarvers = context.m_255420_(Registries.f_257003_);
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        HolderSet.Named overworldBiomes = biomes.m_254956_(BiomeTags.f_215817_);
        context.m_255272_(ExplorationWorldFeatures.createBiomeModifierKey("add_ruby_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(RUBY_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.rubyOreKey));
        context.m_255272_(ExplorationWorldFeatures.createBiomeModifierKey("add_sapphire_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(SAPPHIRE_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.sapphireOreKey));
        context.m_255272_(ExplorationWorldFeatures.createBiomeModifierKey("add_peridot_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(PERIDOT_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.peridotOreKey));
        context.m_255272_(ExplorationWorldFeatures.createBiomeModifierKey("add_electrotine_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(ELECTROTINE_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.electrotineOreKey));
        context.m_255272_(ExplorationWorldFeatures.createBiomeModifierKey("add_tin_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(TIN_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.tinOreKey));
        context.m_255272_(ExplorationWorldFeatures.createBiomeModifierKey("add_silver_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(SILVER_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, Configurator.silverOreKey));
        context.m_255272_(ExplorationWorldFeatures.createBiomeModifierKey("add_marble_cave_to_overworld"), (Object)new ConfigFileControlledAddCarversBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<ConfiguredWorldCarver<?>>)HolderSet.m_205809_((Holder[])new Holder[]{worldCarvers.m_255043_(MARBLE_CAVE_CONFIGURED_CARVER)}), GenerationStep.Carving.AIR, Configurator.marbleCaveKey));
    }

    private static void registerOreConfiguration(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Supplier<Block> standard, Supplier<Block> deepslate, int veinSize) {
        context.m_255272_(key, (Object)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144266_), (BlockState)standard.get().m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144266_), (BlockState)deepslate.get().m_49966_())), veinSize)));
    }

    private static void registerOrePlacement(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuredFeature, int minY, int maxY, int count) {
        ImmutableList modifiers = ImmutableList.of((Object)CountPlacement.m_191628_((int)count), (Object)InSquarePlacement.m_191715_(), (Object)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)));
        context.m_255272_(key, (Object)new PlacedFeature(configuredFeature, (List)modifiers));
    }

    static {
        MARBLE_CAVE_CONFIGURED_CARVER = ExplorationWorldFeatures.createCarverKey(ID_MARBLE_CAVE_CARVER);
        RUBY_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("ruby_ore");
        SAPPHIRE_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("sapphire_ore");
        PERIDOT_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("peridot_ore");
        ELECTROTINE_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("electrotine_ore");
        TIN_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("tin_ore");
        SILVER_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("silver_ore");
        RUBY_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("ruby_ore");
        SAPPHIRE_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("sapphire_ore");
        PERIDOT_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("peridot_ore");
        ELECTROTINE_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("electrotine_ore");
        TIN_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("tin_ore");
        SILVER_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("silver_ore");
    }
}

