/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.GroundFinder;
import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDisc;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabase;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import com.ferreusveritas.dynamictrees.worldgen.DynamicTreeFeature;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CaveRootedTreeFeature
extends DynamicTreeFeature {
    @Override
    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        ResourceLocation dimensionName = level.m_6018_().m_46472_().m_135782_();
        if (BiomeDatabases.isBlacklisted(dimensionName)) {
            return false;
        }
        BlockPos originPos = context.m_159777_();
        ChunkPos chunkPos = new ChunkPos(context.m_159777_());
        LevelContext levelContext = LevelContext.create((LevelAccessor)level);
        PoissonDisc disc = this.getDisc(levelContext, chunkPos, originPos).orElse(null);
        if (disc == null) {
            return false;
        }
        List<BlockPos> groundPositions = GroundFinder.getGroundFinder((Level)level.m_6018_()).findGround((LevelAccessor)level, originPos, null);
        if (groundPositions.isEmpty()) {
            return false;
        }
        BiomeDatabase.Entry biomeEntry = BiomeDatabases.getDefault().getEntry((Holder<Biome>)level.m_6018_().m_204166_(originPos));
        if (biomeEntry.getCaveRootedData() == null) {
            return false;
        }
        BiomeDatabase.CaveRootedData caveRootedData = biomeEntry.getCaveRootedData();
        if ((groundPositions = groundPositions.stream().filter(pos -> pos != BlockPos.f_121853_).sorted(Comparator.comparingInt(Vec3i::m_123342_)).toList()).isEmpty()) {
            return false;
        }
        if (caveRootedData.shouldGenerateOnSurface()) {
            groundPositions = List.of(groundPositions.get(groundPositions.size() - 1));
        }
        AtomicBoolean generated = new AtomicBoolean(false);
        groundPositions.forEach(groundPos -> {
            DynamicTreeFeature.GeneratorResult result = this.generateTree(levelContext, biomeEntry, disc, originPos, (BlockPos)groundPos, SafeChunkBounds.ANY_WG);
            if (result == DynamicTreeFeature.GeneratorResult.GENERATED) {
                generated.set(true);
            }
        });
        return generated.get();
    }

    @Override
    protected BiomePropertySelectors.SpeciesSelector getSpeciesSelector(BiomeDatabase.EntryReader biomeEntry) {
        BiomeDatabase.Entry entry;
        if (biomeEntry instanceof BiomeDatabase.Entry && (entry = (BiomeDatabase.Entry)biomeEntry).getCaveRootedData() != null) {
            return entry.getCaveRootedData().getCaveRootedSpeciesSelector();
        }
        return biomeEntry.getSpeciesSelector();
    }

    @Override
    protected BiomePropertySelectors.ChanceSelector getChanceSelector(BiomeDatabase.EntryReader biomeEntry) {
        BiomeDatabase.Entry entry;
        if (biomeEntry instanceof BiomeDatabase.Entry && (entry = (BiomeDatabase.Entry)biomeEntry).getCaveRootedData() != null) {
            return entry.getCaveRootedData().getCaveRootedChanceSelector();
        }
        return biomeEntry.getChanceSelector();
    }

    private Optional<PoissonDisc> getDisc(LevelContext levelContext, ChunkPos chunkPos, BlockPos originPos) {
        return DISC_PROVIDER.getPoissonDiscs(levelContext, chunkPos).stream().filter(disc -> disc.x == originPos.m_123341_() && disc.z == originPos.m_123343_()).findFirst();
    }

    private Optional<BlockPos> getNextGroundPos(BlockPos originPos, List<BlockPos> groundPositions) {
        for (BlockPos groundPos : groundPositions) {
            if (groundPos.m_123342_() <= originPos.m_123342_()) continue;
            return Optional.of(groundPos);
        }
        return Optional.empty();
    }
}

