/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substance;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substance.SubstanceEffect;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.systems.nodemapper.TransformNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class TransformSubstance
implements SubstanceEffect {
    private final Species toSpecies;

    public TransformSubstance(Species toTree) {
        this.toSpecies = toTree;
    }

    @Override
    public boolean apply(Level level, BlockPos rootPos) {
        Species fromSpecies;
        BlockState rootyState = level.m_8055_(rootPos);
        RootyBlock dirt = TreeHelper.getRooty(rootyState);
        if (dirt != null && this.toSpecies.isValid() && (fromSpecies = dirt.getSpecies(rootyState, (LevelAccessor)level, rootPos)).isTransformable() && fromSpecies != this.toSpecies) {
            if (level.f_46443_) {
                TreeHelper.treeParticles(level, rootPos, ParticleTypes.f_123815_, 8);
            } else {
                dirt.startAnalysis((LevelAccessor)level, rootPos, new MapSignal(new TransformNode(fromSpecies, this.toSpecies)));
            }
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "transform";
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

