/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substance;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substance.SubstanceEffect;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.systems.nodemapper.DenuderNode;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class DenudeSubstance
implements SubstanceEffect {
    @Override
    public boolean apply(Level level, BlockPos rootPos) {
        BlockState rootState = level.m_8055_(rootPos);
        RootyBlock dirt = TreeHelper.getRooty(rootState);
        if (dirt == null) {
            return false;
        }
        Species species = dirt.getSpecies(rootState, (LevelAccessor)level, rootPos);
        Family family = species.getFamily();
        if (!family.hasStrippedBranch()) {
            return false;
        }
        dirt.setFertility(level, rootPos, 0);
        if (level.f_46443_) {
            TreeHelper.treeParticles(level, rootPos, ParticleTypes.f_123783_, 8);
        } else {
            dirt.startAnalysis((LevelAccessor)level, rootPos, new MapSignal(new DenuderNode(species, family)));
        }
        return true;
    }

    @Override
    public String getName() {
        return "denude";
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

