/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemapper;

import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.systems.BranchConnectables;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class CoderNode
implements NodeInspector {
    private final ArrayList<Link> links = new ArrayList();

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        if (BranchConnectables.isBlockConnectable(level.m_8055_(pos).m_60734_())) {
            return false;
        }
        Link link = new Link(pos);
        for (int i = this.links.size() - 1; i >= 0; --i) {
            Link l = this.links.get(i);
            if (pos.m_123341_() + fromDir.m_122429_() != l.pos.m_123341_() || pos.m_123342_() + fromDir.m_122430_() != l.pos.m_123342_() || pos.m_123343_() + fromDir.m_122431_() != l.pos.m_123343_()) continue;
            l.links[fromDir.m_122424_().ordinal()] = link;
            link.links[fromDir.ordinal()] = l;
            l.forks = l.forks + (i != this.links.size() - 1 ? 1 : 0);
            break;
        }
        this.links.add(link);
        return false;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return false;
    }

    public byte[] compile(JoCode joCode) {
        JoCode.CodeCompiler cc = new JoCode.CodeCompiler();
        if (this.links.size() > 0) {
            this.nextLink(cc, this.links.get(0), null);
        }
        return cc.compile();
    }

    private void nextLink(JoCode.CodeCompiler cc, Link link, Link fromLink) {
        for (int dir = 0; dir < 6; ++dir) {
            Link l = link.links[dir];
            if (l == null || l == fromLink) continue;
            if (link.forks > 0) {
                cc.addFork();
            }
            cc.addDirection((byte)dir);
            this.nextLink(cc, l, link);
            if (link.forks <= 0) continue;
            cc.addReturn();
            --link.forks;
        }
    }

    private class Link {
        BlockPos pos;
        int forks;
        Link[] links;

        public Link(BlockPos pos) {
            this.pos = pos;
            this.links = new Link[6];
        }
    }
}

