/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.growthlogic;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class ConiferLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Float> ENERGY_DIVISOR = ConfigurationProperty.floatProperty("energy_divisor");
    public static final ConfigurationProperty<Float> HORIZONTAL_LIMITER = ConfigurationProperty.floatProperty("horizontal_limiter");
    public static final ConfigurationProperty<Boolean> VARIATE_LOWEST_BRANCH = ConfigurationProperty.bool("variate_lowest_branch");

    public ConiferLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(ENERGY_DIVISOR, Float.valueOf(3.0f))).with(HORIZONTAL_LIMITER, Float.valueOf(16.0f))).with(HEIGHT_VARIATION, 5)).with(VARIATE_LOWEST_BRANCH, false);
    }

    @Override
    protected void registerProperties() {
        this.register(ENERGY_DIVISOR, HORIZONTAL_LIMITER, HEIGHT_VARIATION, VARIATE_LOWEST_BRANCH);
    }

    @Override
    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Direction newDir = super.selectNewDirection(configuration, context);
        if (context.signal().isInTrunk() && newDir != Direction.UP) {
            context.signal().energy /= configuration.get(ENERGY_DIVISOR).floatValue();
            Float horizontalLimiter = configuration.get(HORIZONTAL_LIMITER);
            if (context.signal().energy > horizontalLimiter.floatValue()) {
                context.signal().energy = horizontalLimiter.floatValue();
            }
        }
        return newDir;
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        Direction originDir = context.signal().dir.m_122424_();
        probMap[0] = 0;
        probMap[1] = context.signal().isInTrunk() ? context.species().getUpProbability() : 0;
        probMap[5] = !context.signal().isInTrunk() || context.signal().isInTrunk() && context.signal().numSteps % 2 == 1 && context.radius() > 1 ? 2 : 0;
        probMap[4] = probMap[5];
        probMap[3] = probMap[5];
        probMap[2] = probMap[5];
        probMap[originDir.ordinal()] = 0;
        int n = context.signal().dir.ordinal();
        probMap[n] = probMap[n] + (context.signal().isInTrunk() ? 0 : (context.signal().numTurns == 1 ? 2 : 1));
        return probMap;
    }

    @Override
    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getEnergy(configuration, context) * context.species().biomeSuitability(context.level(), context.pos()) + this.getHashVariation(configuration, context);
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) + (configuration.get(VARIATE_LOWEST_BRANCH) != false ? this.getHashVariation(configuration, context) : 1.0f));
    }

    protected float getHashVariation(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        long day = context.level().m_46467_() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode(context.pos().m_6630_(month), 2) % (Integer)configuration.get(HEIGHT_VARIATION);
    }
}

