/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.network;

import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.systems.nodemapper.CollectorNode;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class MapSignal {
    protected ArrayList<NodeInspector> nodeInspectors = new ArrayList();
    public BlockPos root;
    public int depth;
    public boolean multiroot = false;
    public boolean destroyLoopedNodes = true;
    public boolean trackVisited = false;
    public Direction localRootDir = null;
    public boolean overflow;
    public boolean foundRoot;

    public MapSignal() {
    }

    public MapSignal(NodeInspector ... nis) {
        this();
        this.nodeInspectors.addAll(Arrays.asList(nis));
    }

    public boolean run(BlockState blockState, LevelAccessor level, BlockPos pos, @Nullable Direction fromDir) {
        for (NodeInspector inspector : this.nodeInspectors) {
            inspector.run(blockState, level, pos, fromDir);
        }
        return false;
    }

    public boolean returnRun(BlockState blockState, LevelAccessor level, BlockPos pos, Direction fromDir) {
        for (NodeInspector inspector : this.nodeInspectors) {
            inspector.returnRun(blockState, level, pos, fromDir);
        }
        return false;
    }

    public ArrayList<NodeInspector> getInspectors() {
        return this.nodeInspectors;
    }

    public boolean doTrackingVisited(BlockPos pos) {
        NodeInspector inspector;
        if (this.nodeInspectors.size() > 0 && (inspector = this.nodeInspectors.get(0)) instanceof CollectorNode) {
            return ((CollectorNode)inspector).contains(pos);
        }
        return false;
    }
}

