/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.data;

import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.data.provider.DTLangProvider;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class SpeciesLangGenerator
implements Generator<DTLangProvider, Species> {
    DTLangProvider provider;

    @Override
    public void generate(DTLangProvider provider, Species input, Generator.Dependencies dependencies) {
        this.provider = provider;
        this.speciesLang(input, input.getLangOverride("species"));
        if (input.hasSeed()) {
            this.itemLang(input.getSeed().get(), input.getLangOverride("seed"));
        }
    }

    @Override
    public Generator.Dependencies gatherDependencies(Species input) {
        return new Generator.Dependencies();
    }

    protected void itemLang(Item entry, Optional<String> override) {
        if (!(entry instanceof BlockItem) || entry instanceof ItemNameBlockItem) {
            this.provider.addItem(() -> entry, override.orElse(this.checkReplace(ForgeRegistries.ITEMS.getKey((Object)entry))));
        }
    }

    protected void speciesLang(Species entry, Optional<String> override) {
        this.provider.add(entry.getLocalizedName(), override.orElse(this.checkReplace(entry.getRegistryName())));
    }

    protected void blockLang(Block entry, Optional<String> blah) {
        this.provider.addBlock(() -> entry, blah.orElse(this.checkReplace(ForgeRegistries.BLOCKS.getKey((Object)entry))));
    }

    protected String checkReplace(ResourceLocation registryObject) {
        return Arrays.stream(registryObject.m_135815_().split("_")).map(StringUtils::capitalize).filter(s -> !s.isBlank()).collect(Collectors.joining(" ")).trim();
    }
}

