/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simplecorelib.api.datagen;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import mod.alexndr.simplecorelib.api.content.MultifunctionPressurePlateBlock;
import mod.alexndr.simplecorelib.api.content.VeryAbstractFurnaceBlock;
import mod.alexndr.simplecorelib.api.datagen.SimpleBlockModelProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class SimpleBlockStateProvider
extends BlockStateProvider {
    private final SimpleBlockModelProvider simpleBlockModels;

    public SimpleBlockStateProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        super(output, modid, exFileHelper);
        this.simpleBlockModels = new SimpleBlockModelProvider(output, modid, exFileHelper){

            public CompletableFuture<?> m_213708_(CachedOutput p_236071_) {
                return null;
            }

            protected void registerModels() {
            }
        };
    }

    public SimpleBlockModelProvider models() {
        return this.simpleBlockModels;
    }

    public ItemModelProvider itemModels() {
        return super.itemModels();
    }

    public ItemModelBuilder basicBlockItem(Block block) {
        ResourceLocation blockItemRL = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)block.m_5456_()));
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(block.m_5456_().toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(blockItemRL.m_135827_(), "block/" + blockItemRL.m_135815_()));
    }

    public void buildBarsBlockState(IronBarsBlock pBars, ResourceLocation texture) {
        this.barsBlockInternal(pBars, ForgeRegistries.BLOCKS.getKey((Object)pBars).toString(), texture);
    }

    protected void barsBlockInternal(IronBarsBlock pBars, String basename, ResourceLocation texture) {
        BlockModelBuilder post = this.models().barsPost(basename + "_post", texture);
        BlockModelBuilder post_ends = this.models().barsPostEnds(basename + "_post_ends", texture);
        BlockModelBuilder cap = this.models().barsCap(basename + "_cap", texture);
        BlockModelBuilder cap_alt = this.models().barsCapAlt(basename + "_cap_alt", texture);
        BlockModelBuilder side = this.models().barsSide(basename + "_side", texture);
        BlockModelBuilder side_alt = this.models().barsSideAlt(basename + "_side_alt", texture);
        this.barsBlock(pBars, (ModelFile)post, (ModelFile)post_ends, (ModelFile)cap, (ModelFile)cap_alt, (ModelFile)side, (ModelFile)side_alt);
    }

    public void barsBlock(IronBarsBlock pBars, ModelFile post, ModelFile post_ends, ModelFile cap, ModelFile cap_alt, ModelFile side, ModelFile side_alt) {
        Direction dir;
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)pBars).part().modelFile(post_ends).addModel()).end();
        MultiPartBlockStateBuilder.PartBuilder p = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(post).addModel();
        for (Map.Entry e : PipeBlock.f_55154_.entrySet()) {
            dir = (Direction)e.getKey();
            if (!dir.m_122434_().m_122479_()) continue;
            p.condition((Property)e.getValue(), (Comparable[])new Boolean[]{false});
        }
        p.end();
        p = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(cap).addModel();
        for (Map.Entry e : PipeBlock.f_55154_.entrySet()) {
            dir = (Direction)e.getKey();
            if (!dir.m_122434_().m_122479_()) continue;
            if (dir == Direction.NORTH) {
                p.condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
                continue;
            }
            p.condition((Property)e.getValue(), (Comparable[])new Boolean[]{false});
        }
        p.end();
        p = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(cap).rotationY(90).addModel();
        for (Map.Entry e : PipeBlock.f_55154_.entrySet()) {
            dir = (Direction)e.getKey();
            if (!dir.m_122434_().m_122479_()) continue;
            if (dir == Direction.EAST) {
                p.condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
                continue;
            }
            p.condition((Property)e.getValue(), (Comparable[])new Boolean[]{false});
        }
        p.end();
        p = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(cap_alt).addModel();
        for (Map.Entry e : PipeBlock.f_55154_.entrySet()) {
            dir = (Direction)e.getKey();
            if (!dir.m_122434_().m_122479_()) continue;
            if (dir == Direction.SOUTH) {
                p.condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
                continue;
            }
            p.condition((Property)e.getValue(), (Comparable[])new Boolean[]{false});
        }
        p.end();
        p = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(cap_alt).rotationY(90).addModel();
        for (Map.Entry e : PipeBlock.f_55154_.entrySet()) {
            dir = (Direction)e.getKey();
            if (!dir.m_122434_().m_122479_()) continue;
            if (dir == Direction.WEST) {
                p.condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
                continue;
            }
            p.condition((Property)e.getValue(), (Comparable[])new Boolean[]{false});
        }
        p.end();
        for (Map.Entry e : PipeBlock.f_55154_.entrySet()) {
            dir = (Direction)e.getKey();
            if (!dir.m_122434_().m_122479_()) continue;
            boolean alt = dir == Direction.SOUTH || dir == Direction.WEST;
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(alt ? side_alt : side).rotationY(dir.m_122434_() == Direction.Axis.X ? 90 : 0).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true}).end();
        }
    }

    public void buildFurnaceBlockState(VeryAbstractFurnaceBlock pFurnace, ModelFile pFurnaceModel, ModelFile pFurnaceModel_lit) {
        this.getVariantBuilder((Block)pFurnace).partialState().with((Property)VeryAbstractFurnaceBlock.FACING, (Comparable)Direction.NORTH).with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel(pFurnaceModel)}).partialState().with((Property)VeryAbstractFurnaceBlock.FACING, (Comparable)Direction.SOUTH).with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel(pFurnaceModel, 0, 180, false)}).partialState().with((Property)VeryAbstractFurnaceBlock.FACING, (Comparable)Direction.WEST).with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel(pFurnaceModel, 0, 270, false)}).partialState().with((Property)VeryAbstractFurnaceBlock.FACING, (Comparable)Direction.EAST).with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel(pFurnaceModel, 0, 90, false)}).partialState().with((Property)VeryAbstractFurnaceBlock.FACING, (Comparable)Direction.NORTH).with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(pFurnaceModel_lit)}).partialState().with((Property)VeryAbstractFurnaceBlock.FACING, (Comparable)Direction.SOUTH).with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(pFurnaceModel_lit, 0, 180, false)}).partialState().with((Property)VeryAbstractFurnaceBlock.FACING, (Comparable)Direction.WEST).with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(pFurnaceModel_lit, 0, 270, false)}).partialState().with((Property)VeryAbstractFurnaceBlock.FACING, (Comparable)Direction.EAST).with((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(pFurnaceModel_lit, 0, 90, false)});
    }

    public void buildWeightedPressurePlateBlockState(MultifunctionPressurePlateBlock pBlock, ModelFile pPlate, ModelFile pPlate_down) {
        this.getVariantBuilder((Block)pBlock).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(0)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(1)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(2)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(3)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(4)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(5)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(6)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(7)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(8)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(9)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(10)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(11)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(12)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(13)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(14)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)}).partialState().with((Property)MultifunctionPressurePlateBlock.f_58198_, (Comparable)Integer.valueOf(15)).setModels(new ConfiguredModel[]{new ConfiguredModel(pPlate_down)});
    }
}

