/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simplecorelib.api.datagen;

import java.util.function.Consumer;
import mod.alexndr.simplecorelib.api.datagen.AbstractRecipeSetBuilder;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RecipeSetBuilder
extends AbstractRecipeSetBuilder {
    public RecipeSetBuilder(String modid) {
        super(modid);
    }

    public ConditionalAdvancement.Builder build_advancement_with_condition(ResourceLocation recipe_id, ICondition condition, CriterionTriggerInstance criterion) {
        return ConditionalAdvancement.builder().addCondition(condition).addAdvancement(Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("minecraft", "recipes/root")).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipe_id)).m_138386_("has_item", criterion));
    }

    public void buildOre2IngotRecipes(Consumer<FinishedRecipe> consumer, Ingredient oreIn, ItemLike ingotOut, CriterionTriggerInstance criterion, float experienceIn, int cookingTimeIn) {
        this.buildOre2IngotRecipes(consumer, oreIn, ingotOut, criterion, experienceIn, cookingTimeIn, null);
    }

    public void buildOre2IngotRecipes(Consumer<FinishedRecipe> consumer, Ingredient oreIn, ItemLike ingotOut, CriterionTriggerInstance criterion, float experienceIn, int cookingTimeIn, String suffix) {
        Object recipe_name = ingotOut.m_5456_().toString() + "_from_smelting";
        if (suffix != null) {
            recipe_name = ((String)recipe_name).concat(suffix);
        }
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)oreIn, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ingotOut, (float)experienceIn, (int)cookingTimeIn).m_126132_((String)recipe_name, criterion).m_126140_(consumer, this.make_resource((String)recipe_name));
        recipe_name = ingotOut.m_5456_().toString() + "_from_blasting";
        if (suffix != null) {
            recipe_name = ((String)recipe_name).concat(suffix);
        }
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)oreIn, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ingotOut, (float)experienceIn, (int)(cookingTimeIn / 2)).m_126132_((String)recipe_name, criterion).m_126140_(consumer, this.make_resource((String)recipe_name));
    }

    public void buildVanillaRecyclingRecipes(Consumer<FinishedRecipe> consumer, Ingredient ingredients, ItemLike nugget, CriterionTriggerInstance criterion, float experienceIn, int cookingTimeIn) {
        String recipe_name = nugget.m_5456_().toString() + "_from_smelting";
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)ingredients, (RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget, (float)experienceIn, (int)cookingTimeIn).m_126132_(recipe_name, criterion).m_126140_(consumer, this.make_resource(recipe_name));
        recipe_name = nugget.m_5456_().toString() + "_from_blasting";
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)ingredients, (RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget, (float)experienceIn, (int)(cookingTimeIn / 2)).m_126132_(recipe_name, criterion).m_126140_(consumer, this.make_resource(recipe_name));
    }

    public void buildSimpleStorageRecipes(Consumer<FinishedRecipe> consumer, ItemLike ingot, ItemLike block, ItemLike nugget, CriterionTriggerInstance criterion) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingot.m_5456_(), (int)9).m_126209_((ItemLike)block.m_5456_()).m_126132_("has_item", criterion).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block.m_5456_()).m_126127_(Character.valueOf('S'), ingot).m_126130_("SSS").m_126130_("SSS").m_126130_("SSS").m_126132_("has_item", criterion).m_176498_(consumer);
        if (nugget != null) {
            String ingot_name = ingot.m_5456_().toString();
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget.m_5456_(), (int)9).m_126209_(ingot).m_126132_("has_item", criterion).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingot).m_126127_(Character.valueOf('S'), (ItemLike)nugget.m_5456_()).m_126130_("SSS").m_126130_("SSS").m_126130_("SSS").m_126132_("has_item", criterion).m_126140_(consumer, this.make_resource(ingot_name + "_from_nuggets"));
        }
    }

    public void buildChunkConversionRecipes(Consumer<FinishedRecipe> consumer, ItemLike nugget, ItemLike medium_chunk, ItemLike large_chunk, CriterionTriggerInstance criterion) {
        String nugget_name = nugget.m_5456_().toString();
        if (medium_chunk != null) {
            String mchunk_name = medium_chunk.m_5456_().toString();
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)medium_chunk).m_126127_(Character.valueOf('S'), (ItemLike)nugget.m_5456_()).m_126130_("SS").m_126130_("SS").m_126132_("has_item", criterion).m_126140_(consumer, this.make_resource(mchunk_name + "_from_nuggets"));
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget.m_5456_(), (int)4).m_126209_(medium_chunk).m_126132_("has_item", criterion).m_126140_(consumer, this.make_resource(nugget_name + "_from_medium_chunk"));
        }
        if (large_chunk != null && medium_chunk != null) {
            String lchunk_name = large_chunk.m_5456_().toString();
            String mchunk_name = medium_chunk.m_5456_().toString();
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)medium_chunk.m_5456_(), (int)2).m_126209_(large_chunk).m_126132_("has_item", criterion).m_126140_(consumer, this.make_resource(mchunk_name + "_from_large_chunk"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)large_chunk.m_5456_()).m_126211_(medium_chunk, 2).m_126209_(nugget).m_126132_("has_item", criterion).m_126140_(consumer, this.make_resource(lchunk_name + "_from_medium_chunks"));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)large_chunk.m_5456_()).m_126211_(nugget, 5).m_126209_(medium_chunk).m_126132_("has_item", criterion).m_126140_(consumer, this.make_resource(lchunk_name + "_from_nuggets"));
        } else if (large_chunk != null) {
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget.m_5456_(), (int)8).m_126209_(large_chunk).m_126132_("has_item", criterion).m_126140_(consumer, this.make_resource(nugget_name + "_from_large_chunk"));
        }
    }

    public void buildModBowRecipe(Consumer<FinishedRecipe> consumer, ResourceLocation bow_name, Ingredient rod_material, Item rod, Ingredient keystone, CriterionTriggerInstance criterion, ICondition condition) {
        Item bow = (Item)ForgeRegistries.ITEMS.getValue(bow_name);
        Ingredient string = Ingredient.m_204132_((TagKey)Tags.Items.STRING);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)rod).m_126124_(Character.valueOf('S'), rod_material).m_126130_("S").m_126130_("S").m_126132_("has_item", criterion).m_176498_(consumer);
        if (condition == null) {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)bow).m_126127_(Character.valueOf('X'), (ItemLike)rod).m_126124_(Character.valueOf('Y'), string).m_126124_(Character.valueOf('Z'), keystone).m_126130_(" XY").m_126130_("Z Y").m_126130_(" XY").m_126132_("has_item", criterion).m_176498_(consumer);
        } else {
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)bow).m_126127_(Character.valueOf('X'), (ItemLike)rod).m_126124_(Character.valueOf('Y'), string).m_126124_(Character.valueOf('Z'), keystone).m_126130_(" XY").m_126130_("Z Y").m_126130_(" XY").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(bow_name, this.build_advancement_with_condition(bow_name, condition, criterion)).build(consumer, bow_name);
        }
    }

    public void buildSimpleArmorSet(Consumer<FinishedRecipe> consumer, Ingredient item, String variant, CriterionTriggerInstance criterion, ICondition condition) {
        ResourceLocation helmet_name = this.make_resource(variant + "_helmet");
        ResourceLocation chestplate_name = this.make_resource(variant + "_chestplate");
        ResourceLocation leggings_name = this.make_resource(variant + "_leggings");
        ResourceLocation boots_name = this.make_resource(variant + "_boots");
        Item helmet = (Item)ForgeRegistries.ITEMS.getValue(helmet_name);
        Item chestplate = (Item)ForgeRegistries.ITEMS.getValue(chestplate_name);
        Item leggings = (Item)ForgeRegistries.ITEMS.getValue(leggings_name);
        Item boots = (Item)ForgeRegistries.ITEMS.getValue(boots_name);
        if (condition == null) {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)helmet).m_126124_(Character.valueOf('S'), item).m_126130_("SSS").m_126130_("S S").m_126130_("   ").m_126132_("has_item", criterion).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)chestplate).m_126124_(Character.valueOf('S'), item).m_126130_("S S").m_126130_("SSS").m_126130_("SSS").m_126132_("has_item", criterion).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)leggings).m_126124_(Character.valueOf('S'), item).m_126130_("SSS").m_126130_("S S").m_126130_("S S").m_126132_("has_item", criterion).m_176498_(consumer);
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)boots).m_126124_(Character.valueOf('S'), item).m_126130_("   ").m_126130_("S S").m_126130_("S S").m_126132_("has_item", criterion).m_176498_(consumer);
        } else {
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)helmet).m_126124_(Character.valueOf('S'), item).m_126130_("SSS").m_126130_("S S").m_126130_("   ").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(helmet_name, this.build_advancement_with_condition(helmet_name, condition, criterion)).build(consumer, helmet_name);
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)chestplate).m_126124_(Character.valueOf('S'), item).m_126130_("S S").m_126130_("SSS").m_126130_("SSS").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(chestplate_name, this.build_advancement_with_condition(chestplate_name, condition, criterion)).build(consumer, chestplate_name);
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)leggings).m_126124_(Character.valueOf('S'), item).m_126130_("SSS").m_126130_("S S").m_126130_("S S").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(leggings_name, this.build_advancement_with_condition(leggings_name, condition, criterion)).build(consumer, leggings_name);
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)boots).m_126124_(Character.valueOf('S'), item).m_126130_("   ").m_126130_("S S").m_126130_("S S").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(boots_name, this.build_advancement_with_condition(boots_name, condition, criterion)).build(consumer, boots_name);
        }
    }

    public void buildSimpleAestheticBlocks(Consumer<FinishedRecipe> consumer, Ingredient item, String variant, CriterionTriggerInstance criterion, ICondition condition) {
        Block brick_slab;
        ResourceLocation bar_name = this.make_resource(variant + "_bars");
        ResourceLocation bricks_name = this.make_resource(variant + "_bricks");
        ResourceLocation brick_stairs_name = this.make_resource(variant + "_brick_stairs");
        ResourceLocation door_name = this.make_resource(variant + "_door");
        ResourceLocation brick_slab_name = this.make_resource(variant + "_brick_slab");
        IForgeRegistry blockReg = ForgeRegistries.BLOCKS;
        Block bar = blockReg.containsKey(bar_name) ? (Block)blockReg.getValue(bar_name) : null;
        Block bricks = blockReg.containsKey(bricks_name) ? (Block)blockReg.getValue(bricks_name) : null;
        Block brick_stairs = blockReg.containsKey(brick_stairs_name) ? (Block)blockReg.getValue(brick_stairs_name) : null;
        Block door = blockReg.containsKey(door_name) ? (Block)blockReg.getValue(door_name) : null;
        Block block = brick_slab = blockReg.containsKey(brick_slab_name) ? (Block)blockReg.getValue(brick_slab_name) : null;
        if (bar != null) {
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bar, (int)16).m_126124_(Character.valueOf('S'), item).m_126130_("SSS").m_126130_("SSS").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(bar_name, this.build_advancement_with_condition(bar_name, condition, criterion)).build(consumer, bar_name);
        }
        if (bricks != null) {
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bricks).m_126124_(Character.valueOf('S'), item).m_126130_("SS").m_126130_("SS").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(bricks_name, this.build_advancement_with_condition(bricks_name, condition, criterion)).build(consumer, bricks_name);
        }
        if (brick_stairs != null && bricks != null) {
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)brick_stairs, (int)4).m_126124_(Character.valueOf('S'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{bricks.m_5456_()})).m_126130_("S  ").m_126130_("SS ").m_126130_("SSS").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(brick_stairs_name, this.build_advancement_with_condition(brick_stairs_name, condition, criterion)).build(consumer, brick_stairs_name);
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((SingleItemRecipeBuilder)SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{bricks.m_5456_()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)brick_stairs).m_126132_("has_item", criterion)).m_176498_(arg_0)).build(consumer, new ResourceLocation(brick_stairs_name + "_stonecutting"));
        }
        if (brick_slab != null && bricks != null) {
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)brick_slab, (int)6).m_126124_(Character.valueOf('S'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{bricks.m_5456_()})).m_126130_("   ").m_126130_("   ").m_126130_("SSS").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(brick_slab_name, this.build_advancement_with_condition(brick_slab_name, condition, criterion)).build(consumer, brick_slab_name);
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((SingleItemRecipeBuilder)SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{bricks.m_5456_()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)brick_slab, (int)2).m_126132_("has_item", criterion)).m_176498_(arg_0)).build(consumer, new ResourceLocation(brick_slab_name + "_stonecutting"));
        }
        if (door != null) {
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)door, (int)3).m_126124_(Character.valueOf('S'), item).m_126130_(" SS").m_126130_(" SS").m_126130_(" SS").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(door_name, this.build_advancement_with_condition(door_name, condition, criterion)).build(consumer, door_name);
        }
    }

    public void buildSimplePressurePlate(Consumer<FinishedRecipe> consumer, Ingredient item, Block pp, CriterionTriggerInstance criterion) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)pp.m_5456_()).m_126124_(Character.valueOf('S'), item).m_126130_("   ").m_126130_("SS ").m_126130_("   ").m_126132_("has_item", criterion).m_176498_(consumer);
    }

    public void buildSimpleToolSet(Consumer<FinishedRecipe> consumer, Ingredient item, String variant, CriterionTriggerInstance criterion, ICondition condition, boolean has_shears) {
        Item shears;
        Item hoe;
        ResourceLocation sword_name = this.make_resource(variant + "_sword");
        ResourceLocation pickaxe_name = this.make_resource(variant + "_pickaxe");
        ResourceLocation axe_name = this.make_resource(variant + "_axe");
        ResourceLocation shovel_name = this.make_resource(variant + "_shovel");
        ResourceLocation hoe_name = this.make_resource(variant + "_hoe");
        ResourceLocation shears_name = has_shears ? this.make_resource(variant + "_shears") : null;
        Ingredient stick = Ingredient.m_204132_((TagKey)Tags.Items.RODS_WOODEN);
        IForgeRegistry itemReg = ForgeRegistries.ITEMS;
        Item sword = itemReg.containsKey(sword_name) ? (Item)itemReg.getValue(sword_name) : null;
        Item pickaxe = itemReg.containsKey(pickaxe_name) ? (Item)itemReg.getValue(pickaxe_name) : null;
        Item axe = itemReg.containsKey(axe_name) ? (Item)itemReg.getValue(axe_name) : null;
        Item shovel = itemReg.containsKey(shovel_name) ? (Item)itemReg.getValue(shovel_name) : null;
        Item item2 = hoe = itemReg.containsKey(hoe_name) ? (Item)itemReg.getValue(hoe_name) : null;
        Item item3 = has_shears ? (itemReg.containsKey(shears_name) ? (Item)itemReg.getValue(shears_name) : null) : (shears = null);
        if (condition == null) {
            if (sword != null) {
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)sword).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_(" S ").m_126130_(" S ").m_126130_(" T ").m_126132_("has_item", criterion).m_176498_(consumer);
            }
            if (axe != null) {
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)axe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SS ").m_126130_("ST ").m_126130_(" T ").m_126132_("has_item", criterion).m_176498_(consumer);
            }
            if (hoe != null) {
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)hoe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SS ").m_126130_(" T ").m_126130_(" T ").m_126132_("has_item", criterion).m_176498_(consumer);
            }
            if (pickaxe != null) {
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)pickaxe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SSS").m_126130_(" T ").m_126130_(" T ").m_126132_("has_item", criterion).m_176498_(consumer);
            }
            if (shovel != null) {
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)shovel).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_(" S ").m_126130_(" T ").m_126130_(" T ").m_126132_("has_item", criterion).m_176498_(consumer);
            }
            if (has_shears && shears != null) {
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)shears).m_126124_(Character.valueOf('S'), item).m_126130_(" S").m_126130_("S ").m_126132_("has_item", criterion).m_176498_(consumer);
            }
        } else {
            if (sword != null) {
                ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)sword).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_(" S ").m_126130_(" S ").m_126130_(" T ").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(sword_name, this.build_advancement_with_condition(sword_name, condition, criterion)).build(consumer, sword_name);
            }
            if (pickaxe != null) {
                ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)pickaxe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SSS").m_126130_(" T ").m_126130_(" T ").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(pickaxe_name, this.build_advancement_with_condition(pickaxe_name, condition, criterion)).build(consumer, pickaxe_name);
            }
            if (axe != null) {
                ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)axe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SS ").m_126130_("ST ").m_126130_(" T ").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(axe_name, this.build_advancement_with_condition(axe_name, condition, criterion)).build(consumer, axe_name);
            }
            if (shovel != null) {
                ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)shovel).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_(" S ").m_126130_(" T ").m_126130_(" T ").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(shovel_name, this.build_advancement_with_condition(shovel_name, condition, criterion)).build(consumer, shovel_name);
            }
            if (hoe != null) {
                ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)hoe).m_126124_(Character.valueOf('S'), item).m_126124_(Character.valueOf('T'), stick).m_126130_("SS ").m_126130_(" T ").m_126130_(" T ").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(hoe_name, this.build_advancement_with_condition(hoe_name, condition, criterion)).build(consumer, hoe_name);
            }
            if (has_shears && shears != null) {
                ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)shears).m_126124_(Character.valueOf('S'), item).m_126130_(" S").m_126130_("S ").m_126132_("has_item", criterion)).m_176498_(arg_0)).setAdvancement(shears_name, this.build_advancement_with_condition(shears_name, condition, criterion)).build(consumer, shears_name);
            }
        }
    }
}

