/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simplecorelib.api.datagen;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import mod.alexndr.simplecorelib.api.helpers.TagUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class MiningItemTags
extends ItemTagsProvider {
    public MiningItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, String modId, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTagProvider, modId, existingFileHelper);
    }

    protected void m_6577_(HolderLookup.Provider lookupProvider) {
        this.registerOreTags();
    }

    protected void registerOreTags() {
    }

    protected void registerArmorTags(DeferredRegister<Item> item_defregistry) {
        this.m_206424_(TagUtils.forgeTag("armors")).m_206428_(TagUtils.forgeTag("armors/helmets")).m_206428_(TagUtils.forgeTag("armors/chestplates")).m_206428_(TagUtils.forgeTag("armors/leggings")).m_206428_(TagUtils.forgeTag("armors/boots"));
        item_defregistry.getEntries().stream().map(RegistryObject::get).filter(entry -> entry instanceof ArmorItem).forEach(armor -> {
            Object foo = ((ArmorItem)armor).m_266204_().m_266355_();
            foo = ((String)foo).endsWith("s") ? foo : (String)foo + "s";
            this.m_206424_(TagUtils.forgeTag("armors/" + (String)foo)).m_255245_(armor);
        });
    }

    protected void registerToolTags(DeferredRegister<Item> item_defregistry) {
        item_defregistry.getEntries().stream().map(RegistryObject::get).filter(entry -> entry instanceof TieredItem).forEach(item -> {
            if (item instanceof SwordItem) {
                this.m_206424_(TagUtils.modTag("minecraft", "swords")).m_255245_(item);
            } else if (item instanceof AxeItem) {
                this.m_206424_(TagUtils.modTag("minecraft", "axes")).m_255245_(item);
            } else if (item instanceof HoeItem) {
                this.m_206424_(TagUtils.modTag("minecraft", "hoes")).m_255245_(item);
            } else if (item instanceof PickaxeItem) {
                this.m_206424_(TagUtils.modTag("minecraft", "pickaxes")).m_255245_(item);
            } else if (item instanceof ShovelItem) {
                this.m_206424_(TagUtils.modTag("minecraft", "shovels")).m_255245_(item);
            }
        });
        this.m_206424_(TagUtils.forgeTag("tools")).m_206428_(TagUtils.forgeTag("tools/bows")).m_206428_(TagUtils.forgeTag("tools/crossbows"));
        item_defregistry.getEntries().stream().map(RegistryObject::get).filter(entry -> entry instanceof ProjectileWeaponItem).forEach(item -> {
            if (item instanceof BowItem) {
                this.m_206424_(TagUtils.forgeTag("tools/bows")).m_255245_(item);
            } else if (item instanceof CrossbowItem) {
                this.m_206424_(TagUtils.forgeTag("tools/crossbows")).m_255245_(item);
            }
        });
        item_defregistry.getEntries().stream().map(RegistryObject::get).filter(entry -> entry instanceof ShearsItem).forEach(item -> this.m_206424_(Tags.Items.SHEARS).m_255245_(item));
    }

    protected void registerOresInGroundTags(Collection<DropExperienceBlock> ore_blocks, Collection<DropExperienceBlock> deepslate_ore_blocks, Collection<DropExperienceBlock> netherrack_ore_blocks) {
        if (ore_blocks != null && !ore_blocks.isEmpty()) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender stone_item = this.m_206424_(Tags.Items.ORES_IN_GROUND_STONE);
            ore_blocks.stream().forEach(b -> stone_item.m_255245_((Object)b.m_5456_()));
        }
        if (deepslate_ore_blocks != null && !deepslate_ore_blocks.isEmpty()) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender deepslate = this.m_206424_(Tags.Items.ORES_IN_GROUND_DEEPSLATE);
            deepslate_ore_blocks.stream().forEach(b -> deepslate.m_255245_((Object)b.m_5456_()));
        }
        if (netherrack_ore_blocks != null && !netherrack_ore_blocks.isEmpty()) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender netherrack = this.m_206424_(Tags.Items.ORES_IN_GROUND_NETHERRACK);
            netherrack_ore_blocks.stream().forEach(b -> netherrack.m_255245_((Object)b.m_5456_()));
        }
    }

    protected void registerOreRateTags(Collection<DropExperienceBlock> sparse_ores, Collection<DropExperienceBlock> singular_ores, Collection<DropExperienceBlock> dense_ores) {
        if (sparse_ores != null && !sparse_ores.isEmpty()) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender sparse = this.m_206424_(Tags.Items.ORE_RATES_SPARSE);
            sparse_ores.stream().forEach(b -> sparse.m_255245_((Object)b.m_5456_()));
        }
        if (singular_ores != null && !singular_ores.isEmpty()) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender singular = this.m_206424_(Tags.Items.ORE_RATES_SINGULAR);
            singular_ores.stream().forEach(b -> singular.m_255245_((Object)b.m_5456_()));
        }
        if (dense_ores != null && !dense_ores.isEmpty()) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender dense = this.m_206424_(Tags.Items.ORE_RATES_DENSE);
            dense_ores.stream().forEach(b -> dense.m_255245_((Object)b.m_5456_()));
        }
    }
}

