/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simplecorelib.api.content;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.alexndr.simplecorelib.api.content.VeryAbstractFurnaceBlock;
import mod.alexndr.simplecorelib.api.helpers.SidedWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class VeryAbstractFurnaceTileEntity
extends BlockEntity {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final int INPUT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    protected static final String INVENTORY_TAG = "inventory";
    protected static final String SMELT_TIME_LEFT_TAG = "smeltTimeProgress";
    protected static final String MAX_SMELT_TIME_TAG = "maxSmeltTime";
    protected static final String FUEL_BURN_TIME_LEFT_TAG = "fuelBurnTimeLeft";
    protected static final String MAX_FUEL_BURN_TIME_TAG = "maxFuelBurnTime";
    public static final int DATA_FUEL_TIME_LEFT = 0;
    public static final int DATA_FUEL_TIME_MAX = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    protected final RecipeType<? extends AbstractCookingRecipe> recipeType;
    protected final Map<ResourceLocation, Integer> recipe2xp_map = Maps.newHashMap();
    protected AbstractCookingRecipe cachedRecipe;
    protected ItemStack failedMatch = ItemStack.f_41583_;
    protected double fuelMultiplier = 1.0;
    protected boolean hasFuelMultiplier = false;
    public int smeltTimeProgress = -1;
    public int maxSmeltTime = -1;
    public int fuelBurnTimeLeft = 0;
    public int maxFuelBurnTime = 0;
    protected boolean lastBurning = false;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return VeryAbstractFurnaceTileEntity.this.fuelBurnTimeLeft;
                }
                case 1: {
                    return VeryAbstractFurnaceTileEntity.this.maxFuelBurnTime;
                }
                case 2: {
                    return VeryAbstractFurnaceTileEntity.this.smeltTimeProgress;
                }
                case 3: {
                    return VeryAbstractFurnaceTileEntity.this.maxSmeltTime;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    VeryAbstractFurnaceTileEntity.this.fuelBurnTimeLeft = value;
                    break;
                }
                case 1: {
                    VeryAbstractFurnaceTileEntity.this.maxFuelBurnTime = value;
                    break;
                }
                case 2: {
                    VeryAbstractFurnaceTileEntity.this.smeltTimeProgress = value;
                    break;
                }
                case 3: {
                    VeryAbstractFurnaceTileEntity.this.maxSmeltTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    public final ItemStackHandler inventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            VeryAbstractFurnaceTileEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            switch (slot) {
                case 1: {
                    return VeryAbstractFurnaceTileEntity.this.isFuel(stack);
                }
                case 0: {
                    return VeryAbstractFurnaceTileEntity.this.isInput(stack);
                }
                case 2: {
                    return VeryAbstractFurnaceTileEntity.this.isOutput(stack);
                }
            }
            return false;
        }
    };
    protected LazyOptional<ItemStackHandler> inventoryCapabilityInternal = LazyOptional.of(() -> this.inventory);
    protected LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalUp = LazyOptional.of(() -> new FurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.UP));
    protected LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalSides = LazyOptional.of(() -> new FurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.EAST));
    protected LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown = LazyOptional.of(() -> new FurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.DOWN));

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return this.inventoryCapabilityInternal.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && side != null) {
            switch (side) {
                case DOWN: {
                    return this.inventoryCapabilityExternalDown.cast();
                }
                case UP: {
                    return this.inventoryCapabilityExternalUp.cast();
                }
                case NORTH: 
                case SOUTH: 
                case WEST: 
                case EAST: {
                    return this.inventoryCapabilityExternalSides.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapabilityExternalUp.invalidate();
        this.inventoryCapabilityExternalDown.invalidate();
        this.inventoryCapabilityExternalSides.invalidate();
        this.inventoryCapabilityInternal.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.inventoryCapabilityInternal = LazyOptional.of(() -> this.inventory);
        this.inventoryCapabilityExternalUp = LazyOptional.of(() -> new FurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.UP));
        this.inventoryCapabilityExternalSides = LazyOptional.of(() -> new FurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.EAST));
        this.inventoryCapabilityExternalDown = LazyOptional.of(() -> new FurnaceHandler((IItemHandlerModifiable)this.inventory, Direction.DOWN));
    }

    public VeryAbstractFurnaceTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos blockpos, BlockState blockstate, RecipeType<? extends AbstractCookingRecipe> recipeTypeIn) {
        super(tileEntityTypeIn, blockpos, blockstate);
        this.recipeType = recipeTypeIn;
    }

    public boolean isFuel(ItemStack stack) {
        return FurnaceBlockEntity.m_58399_((ItemStack)stack) || stack.m_150930_(Items.f_42446_);
    }

    protected boolean isInput(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return this.getRecipe(stack).isPresent();
    }

    protected boolean isOutput(ItemStack stack) {
        Optional<ItemStack> result = this.getResult(this.inventory.getStackInSlot(0));
        return result.isPresent() && ItemStack.m_41656_((ItemStack)result.get(), (ItemStack)stack);
    }

    public boolean isBurning() {
        return this.fuelBurnTimeLeft > 0;
    }

    protected Optional<AbstractCookingRecipe> getRecipe(Container inv0) {
        if (this.cachedRecipe != null && this.cachedRecipe.m_5818_(inv0, this.f_58857_)) {
            return Optional.of(this.cachedRecipe);
        }
        AbstractCookingRecipe rec = this.f_58857_.m_7465_().m_44015_(this.recipeType, inv0, this.f_58857_).orElse(null);
        this.failedMatch = rec == null ? inv0.m_8020_(0) : ItemStack.f_41583_;
        this.cachedRecipe = rec;
        return Optional.ofNullable(rec);
    }

    protected Optional<AbstractCookingRecipe> getRecipe(ItemStack input) {
        if (input.m_41619_() || input == this.failedMatch) {
            return Optional.empty();
        }
        return this.getRecipe((Container)new SimpleContainer(new ItemStack[]{input}));
    }

    public void setRecipeUsed(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            this.recipe2xp_map.compute(recipe.m_6423_(), (p_214004_0_, p_214004_1_) -> 1 + (p_214004_1_ == null ? 0 : p_214004_1_));
        }
    }

    protected Optional<ItemStack> getResult(ItemStack input) {
        SimpleContainer dummyInventory = new SimpleContainer(new ItemStack[]{input});
        Optional<ItemStack> maybe_result = this.getRecipe((Container)dummyInventory).map(recipe -> recipe.m_5874_((Container)dummyInventory, this.f_58857_.m_9598_()));
        return Optional.of(maybe_result.orElse(ItemStack.f_41583_));
    }

    protected int getBurnDuration(ItemStack fuelstack) {
        int returnval = 0;
        returnval = !this.hasFuelMultiplier ? ForgeHooks.getBurnTime((ItemStack)fuelstack, this.recipeType) : (int)Math.ceil((double)ForgeHooks.getBurnTime((ItemStack)fuelstack, this.recipeType) * this.fuelMultiplier);
        return returnval;
    }

    protected boolean canSmelt(ItemStack result) {
        if (!this.inventory.getStackInSlot(0).m_41619_() && !result.m_41619_()) {
            ItemStack outstack = this.inventory.getStackInSlot(2);
            if (outstack.m_41619_()) {
                return true;
            }
            if (!outstack.m_150930_(result.m_41720_())) {
                return false;
            }
            return outstack.m_41613_() + result.m_41613_() <= outstack.m_41741_();
        }
        return false;
    }

    protected short getSmeltTime(ItemStack input) {
        return this.getRecipe(input).map(AbstractCookingRecipe::m_43753_).orElse(200).shortValue();
    }

    protected void smelt(ItemStack result) {
        if (!result.m_41619_() && this.canSmelt(result)) {
            ItemStack inputStack = this.inventory.getStackInSlot(0).m_41777_();
            ItemStack outstack = this.inventory.getStackInSlot(2).m_41777_();
            if (outstack.m_41619_()) {
                this.inventory.setStackInSlot(2, result.m_41777_());
            } else if (outstack.m_41720_() == result.m_41720_()) {
                outstack.m_41769_(result.m_41613_());
                this.inventory.setStackInSlot(2, outstack);
            }
            if (!this.f_58857_.f_46443_) {
                this.setRecipeUsed(this.getRecipe(inputStack).orElse(null));
            }
            ItemStack fuelStack = this.inventory.getStackInSlot(1).m_41777_();
            if (inputStack.m_41720_() == Blocks.f_50057_.m_5456_() && !fuelStack.m_41619_() && fuelStack.m_41720_() == Items.f_42446_) {
                this.inventory.setStackInSlot(1, new ItemStack((ItemLike)Items.f_42447_));
            }
            inputStack.m_41774_(1);
            this.inventory.setStackInSlot(0, inputStack);
        }
    }

    public static void serverTick(Level level, BlockPos blockpos, BlockState blockstate, VeryAbstractFurnaceTileEntity tile) {
        boolean hasFuel = tile.isBurning();
        boolean flag1 = false;
        if (tile.isBurning()) {
            --tile.fuelBurnTimeLeft;
        }
        if (((Boolean)blockstate.m_61143_((Property)VeryAbstractFurnaceBlock.LIT)).booleanValue() != tile.isBurning()) {
            blockstate = (BlockState)blockstate.m_61124_((Property)VeryAbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(tile.isBurning()));
            level.m_7731_(blockpos, blockstate, 3);
        }
        ItemStack input = tile.inventory.getStackInSlot(0).m_41777_();
        ItemStack fuel = tile.inventory.getStackInSlot(1).m_41777_();
        ItemStack result = tile.getResult(input).orElse(ItemStack.f_41583_);
        if (!(!tile.isBurning() && fuel.m_41619_() || input.m_41619_())) {
            if (!tile.isBurning() && tile.canSmelt(result)) {
                tile.maxFuelBurnTime = tile.fuelBurnTimeLeft = tile.getBurnDuration(fuel);
                if (tile.isBurning()) {
                    flag1 = true;
                    if (fuel.hasCraftingRemainingItem()) {
                        tile.inventory.setStackInSlot(1, fuel.getCraftingRemainingItem());
                    } else if (!fuel.m_41619_()) {
                        fuel.m_41774_(1);
                        tile.inventory.setStackInSlot(1, fuel);
                    }
                }
            }
            if (tile.isBurning() && tile.canSmelt(result)) {
                if (tile.smeltTimeProgress <= 0) {
                    tile.maxSmeltTime = tile.getSmeltTime(tile.inventory.getStackInSlot(0));
                    tile.smeltTimeProgress = 0;
                }
                ++tile.smeltTimeProgress;
                if (tile.smeltTimeProgress >= tile.maxSmeltTime) {
                    tile.smelt(result);
                    tile.smeltTimeProgress = 0;
                    tile.maxSmeltTime = !tile.inventory.getStackInSlot(0).m_41619_() ? (int)tile.getSmeltTime(tile.inventory.getStackInSlot(0)) : 0;
                    flag1 = true;
                }
            } else {
                tile.smeltTimeProgress = 0;
            }
        } else if (!tile.isBurning() && tile.smeltTimeProgress > 0) {
            tile.smeltTimeProgress = (short)Mth.m_14045_((int)(tile.smeltTimeProgress - 2), (int)0, (int)tile.maxSmeltTime);
        }
        if (hasFuel != tile.isBurning()) {
            flag1 = true;
            blockstate = (BlockState)blockstate.m_61124_((Property)VeryAbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(tile.isBurning()));
            level.m_7731_(blockpos, blockstate, 3);
        }
        if (flag1) {
            VeryAbstractFurnaceTileEntity.m_155232_((Level)level, (BlockPos)blockpos, (BlockState)blockstate);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.lastBurning = this.isBurning();
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_(INVENTORY_TAG));
        this.smeltTimeProgress = compound.m_128451_(SMELT_TIME_LEFT_TAG);
        this.maxSmeltTime = compound.m_128451_(MAX_SMELT_TIME_TAG);
        this.fuelBurnTimeLeft = compound.m_128451_(FUEL_BURN_TIME_LEFT_TAG);
        this.maxFuelBurnTime = compound.m_128451_(MAX_FUEL_BURN_TIME_TAG);
        if (this.m_58898_() && !this.f_58857_.f_46443_) {
            this.lastBurning = this.isBurning();
        }
        int ii = compound.m_128448_("RecipesUsedSize");
        for (int jj = 0; jj < ii; ++jj) {
            ResourceLocation resourcelocation = new ResourceLocation(compound.m_128461_("RecipeLocation" + jj));
            int kk = compound.m_128451_("RecipeAmount" + jj);
            this.recipe2xp_map.put(resourcelocation, kk);
        }
        if (this.m_58898_()) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.isBurning())));
        }
    }

    @Nonnull
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
        compound.m_128405_(SMELT_TIME_LEFT_TAG, this.smeltTimeProgress);
        compound.m_128405_(MAX_SMELT_TIME_TAG, this.maxSmeltTime);
        compound.m_128405_(FUEL_BURN_TIME_LEFT_TAG, this.fuelBurnTimeLeft);
        compound.m_128405_(MAX_FUEL_BURN_TIME_TAG, this.maxFuelBurnTime);
        compound.m_128376_("RecipesUsedSize", (short)this.recipe2xp_map.size());
        int ii = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipe2xp_map.entrySet()) {
            compound.m_128359_("RecipeLocation" + ii, entry.getKey().toString());
            compound.m_128405_("RecipeAmount" + ii, entry.getValue().intValue());
            ++ii;
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbtTag = pkt.m_131708_();
        this.m_142466_(nbtTag);
    }

    public void grantExperience(Player player) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, Integer> entry : this.recipe2xp_map.entrySet()) {
            player.m_9236_().m_7465_().m_44043_(entry.getKey()).ifPresent(p_213993_3_ -> {
                list.add(p_213993_3_);
                VeryAbstractFurnaceTileEntity.spawnExpOrbs(player, (Integer)entry.getValue(), ((AbstractCookingRecipe)p_213993_3_).m_43750_());
            });
        }
        player.m_7281_((Collection)list);
        this.recipe2xp_map.clear();
    }

    protected static void spawnExpOrbs(Player player, int pCount, float experience) {
        if (experience == 0.0f) {
            pCount = 0;
        } else if (experience < 1.0f) {
            int i = Mth.m_14143_((float)((float)pCount * experience));
            if (i < Mth.m_14167_((float)((float)pCount * experience)) && Math.random() < (double)((float)pCount * experience - (float)i)) {
                ++i;
            }
            pCount = i;
        }
        while (pCount > 0) {
            int j = ExperienceOrb.m_20782_((int)pCount);
            pCount -= j;
            player.m_9236_().m_7967_((Entity)new ExperienceOrb(player.m_9236_(), player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, j));
        }
    }

    public class FurnaceHandler
    extends SidedWrapper {
        public FurnaceHandler(IItemHandlerModifiable inventory, Direction side) {
            super(inventory, side);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot == 2) {
                return stack;
            }
            if (slot == 0 && this.side == Direction.UP) {
                return super.insertItem(slot, stack, simulate);
            }
            if (slot == 1 && this.isHorizontalSide(this.side)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 1 && this.side == Direction.DOWN) {
                ItemStack pstack = this.getStackInSlot(1);
                if (pstack.m_150930_(Items.f_42446_) || pstack.m_150930_(Items.f_42447_)) {
                    return super.extractItem(slot, amount, simulate);
                }
                return ItemStack.f_41583_;
            }
            if (slot == 2 && this.side == Direction.DOWN) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }
    }
}

