/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simplecorelib.api.content;

import javax.annotation.Nonnull;
import mod.alexndr.simplecorelib.api.content.VeryAbstractFurnaceTileEntity;
import mod.alexndr.simplecorelib.api.helpers.FurnaceResultSlotItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public abstract class VeryAbstractFurnaceMenu
extends AbstractContainerMenu {
    public static final int INGREDIENT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    public static final int SLOT_COUNT = 3;
    public static final int DATA_COUNT = 4;
    public static final int DATA_FUEL_TIME_LEFT = 0;
    public static final int DATA_FUEL_TIME_MAX = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    protected final BlockEntity blockEntity;
    protected IItemHandler playerInventory;
    protected final RecipeType<? extends AbstractCookingRecipe> recipeType;
    protected final Player playerEntity;
    protected Container recipeInv;
    protected ContainerData data;

    protected VeryAbstractFurnaceMenu(MenuType<?> menutype, int id, BlockPos pos, Inventory playerInventory, Player player, RecipeType<? extends AbstractCookingRecipe> recipetype) {
        super(menutype, id);
        this.blockEntity = player.m_20193_().m_7702_(pos);
        this.recipeType = recipetype;
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        if (this.blockEntity != null && this.blockEntity instanceof VeryAbstractFurnaceTileEntity) {
            this.recipeInv = new RecipeWrapper((IItemHandlerModifiable)((VeryAbstractFurnaceTileEntity)this.blockEntity).inventory);
            this.data = ((VeryAbstractFurnaceTileEntity)this.blockEntity).dataAccess;
            this.m_38884_(this.data);
            this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
                this.m_38897_((Slot)new SlotItemHandler(h, 0, 56, 17));
                this.m_38897_((Slot)new SlotItemHandler(h, 1, 56, 53));
                this.m_38897_((Slot)new FurnaceResultSlotItemHandler(player, (IItemHandler)h, this.blockEntity, 2, 116, 35));
            });
        }
        int playerInventoryStartX = 8;
        int playerInventoryStartY = 84;
        this.layoutPlayerInventorySlots(8, 84);
    }

    protected int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    protected int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack returnStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            returnStack = slotStack.m_41777_();
            int containerSlots = this.f_38839_.size() - player.m_150109_().f_35974_.size();
            if (index < containerSlots ? !this.m_38903_(slotStack, containerSlots, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, containerSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == returnStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return returnStack;
    }

    public boolean recipeMatches(Recipe<? super Container> recipe) {
        return recipe.m_5818_(this.recipeInv, this.blockEntity.m_58904_());
    }

    public boolean m_6875_(Player player) {
        return VeryAbstractFurnaceMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public void clearCraftingContent() {
        this.m_38853_(0).m_5852_(ItemStack.f_41583_);
        this.m_38853_(2).m_5852_(ItemStack.f_41583_);
    }

    public int getResultSlotIndex() {
        return 2;
    }

    public int getGridWidth() {
        return 1;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 3;
    }

    public int getBurnProgress() {
        int i = this.data.m_6413_(2);
        int j = this.data.m_6413_(3);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getLitProgress() {
        int i = this.data.m_6413_(1);
        int j = this.data.m_6413_(0);
        if (i == 0) {
            i = 200;
        }
        return j * 13 / i;
    }

    public boolean isLit() {
        return this.data.m_6413_(0) > 0;
    }
}

