/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simplecorelib.api.content;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class MultifunctionPressurePlateBlock
extends WeightedPressurePlateBlock {
    protected final Sensitivity sensitivity;
    protected final boolean is_weighted;
    protected final int pressTime;

    public MultifunctionPressurePlateBlock(int pMaxWeight, Sensitivity pSensitify, int pPressedTime, BlockBehaviour.Properties pProperties, BlockSetType pSetType) {
        super(pMaxWeight, pProperties, pSetType);
        this.sensitivity = pSensitify;
        this.pressTime = pPressedTime;
        this.is_weighted = List.of(Sensitivity.EVERYTHING_WEIGHTED, Sensitivity.MOBS_WEIGHTED, Sensitivity.PLAYERS_WEIGHTED, Sensitivity.LIVING_WEIGHTED).contains((Object)this.sensitivity);
    }

    protected int m_7342_() {
        return this.pressTime;
    }

    protected int m_6693_(Level pLevel, BlockPos pPos) {
        List list;
        AABB aabb = f_49287_.m_82338_(pPos);
        switch (this.sensitivity) {
            case EVERYTHING: 
            case EVERYTHING_WEIGHTED: {
                list = pLevel.m_45933_((Entity)null, aabb);
                break;
            }
            case LIVING: 
            case LIVING_WEIGHTED: {
                list = pLevel.m_6443_(LivingEntity.class, aabb, arg0 -> !(arg0 instanceof ArmorStand));
                break;
            }
            case MOBS: 
            case MOBS_WEIGHTED: {
                list = pLevel.m_45976_(Mob.class, aabb);
                break;
            }
            case PLAYERS: 
            case PLAYERS_WEIGHTED: {
                list = pLevel.m_45976_(Player.class, aabb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (this.is_weighted) {
            int i = Math.min(list.size(), this.f_58199_);
            if (i > 0) {
                float f = (float)Math.min(this.f_58199_, i) / (float)this.f_58199_;
                return Mth.m_14167_((float)(f * 15.0f));
            }
            return 0;
        }
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_6090_()) continue;
                return 15;
            }
        }
        return 0;
    }

    protected int m_6016_(BlockState pState) {
        if (this.is_weighted) {
            return (Integer)pState.m_61143_((Property)f_58198_);
        }
        return (Integer)pState.m_61143_((Property)f_58198_) > 0 ? 15 : 0;
    }

    protected BlockState m_7422_(BlockState pState, int pStrength) {
        return (BlockState)pState.m_61124_((Property)f_58198_, (Comparable)Integer.valueOf(pStrength));
    }

    public void m_5871_(ItemStack pStack, BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        String tipKey = null;
        switch (this.sensitivity) {
            case EVERYTHING: 
            case EVERYTHING_WEIGHTED: {
                tipKey = "tips.pressure_plate.everything";
                break;
            }
            case LIVING: 
            case LIVING_WEIGHTED: {
                tipKey = "tips.pressure_plate.living";
                break;
            }
            case MOBS: 
            case MOBS_WEIGHTED: {
                tipKey = "tips.pressure_plate.mobs";
                break;
            }
            case PLAYERS: 
            case PLAYERS_WEIGHTED: {
                tipKey = "tips.pressure_plate.players";
            }
        }
        pTooltip.add((Component)Component.m_237115_((String)tipKey).m_130940_(ChatFormatting.GREEN));
    }

    public static enum Sensitivity {
        EVERYTHING,
        LIVING,
        MOBS,
        PLAYERS,
        EVERYTHING_WEIGHTED,
        LIVING_WEIGHTED,
        MOBS_WEIGHTED,
        PLAYERS_WEIGHTED;

    }
}

