/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simplecorelib.api.client;

import java.util.function.Predicate;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ComputeFovModifierEvent;

public final class ClientUtils {
    public static void handleFovEvent(ComputeFovModifierEvent event, Predicate<Item> itemChecker, float zoomVal) {
        float baseFOV = event.getFovModifier();
        float myNewFOV = 1.0f;
        ItemStack heldItemStack = event.getPlayer().m_21205_();
        if (heldItemStack.m_41619_()) {
            return;
        }
        Item heldItem = heldItemStack.m_41720_();
        int useRemaining = event.getPlayer().m_21252_();
        if (heldItem instanceof BowItem) {
            float zoom = 1.0f;
            if (!itemChecker.test(heldItem)) {
                return;
            }
            zoom = zoomVal;
            myNewFOV = baseFOV - (float)useRemaining * zoom / 20.0f;
            if (myNewFOV < baseFOV - zoom) {
                myNewFOV = baseFOV - zoom;
            }
            event.setNewFovModifier(myNewFOV);
        }
    }

    public static void setupBowModelProperties(Item bow) {
        ItemProperties.register((Item)bow, (ResourceLocation)new ResourceLocation("pull"), (p0, p1, p2, p4) -> {
            if (p2 == null) {
                return 0.0f;
            }
            return p2.m_21211_() != p0 ? 0.0f : (float)(p0.m_41779_() - p2.m_21212_()) / 20.0f;
        });
        ItemProperties.register((Item)bow, (ResourceLocation)new ResourceLocation("pulling"), (p0, p1, p2, p4) -> p2 != null && p2.m_6117_() && p2.m_21211_() == p0 ? 1.0f : 0.0f);
    }

    public static double[] findBlockParticleVector(BlockPos pos, RandomSource rand, float fact1, float fact2) {
        double[] pv = new double[6];
        float f1 = (float)pos.m_123341_() - fact1;
        float f2 = (float)pos.m_123342_() - fact1;
        float f3 = (float)pos.m_123343_() - fact1;
        float f4 = rand.m_188501_() * fact2;
        float f5 = rand.m_188501_() * fact2;
        float f6 = rand.m_188501_() * fact2;
        pv[0] = f1 + f4;
        pv[1] = f2 + f5;
        pv[2] = f3 + f6;
        pv[3] = 0.0;
        pv[4] = 0.0;
        pv[5] = 0.0;
        return pv;
    }

    public static double[] findBlockParticleVector(BlockPos pos, RandomSource rand) {
        return ClientUtils.findBlockParticleVector(pos, rand, 0.5f, 2.0f);
    }
}

