/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class PneumaticTubePayload {
    public static final int MAX_PROGRESS = 255;
    private int progress;
    private int speed;
    private int inputSide = -1;
    private int outputSide = -1;
    private ItemStack itemStack;

    public PneumaticTubePayload(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public PneumaticTubePayload() {
        this(ItemStack.f_41583_);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setProgress(int prog) {
        this.progress = prog;
    }

    public void setSpeed(int spd) {
        this.speed = spd;
    }

    public void incrementProgress() {
        this.progress += this.speed;
    }

    public void setInputSide(int s) {
        this.inputSide = s;
    }

    public void setOutputSide(int s) {
        this.outputSide = s;
    }

    public int getInputSide() {
        return this.inputSide;
    }

    public int getOutputSide() {
        return this.outputSide;
    }

    public boolean hasOutputSide() {
        return this.outputSide != -1;
    }

    public void resetOutput() {
        this.outputSide = -1;
    }

    public void resetProgress() {
        this.progress = Math.max(0, this.progress - 255);
    }

    public boolean isPassedHalfWay() {
        return this.progress > 127;
    }

    public int getCurrentSide() {
        return this.progress < 127 ? this.inputSide : this.outputSide;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void save(CompoundTag tag) {
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("speed", this.speed);
        tag.m_128405_("input_dir", this.inputSide);
        tag.m_128405_("output_dir", this.outputSide);
        tag.m_128365_("item_stack", (Tag)this.itemStack.m_41739_(new CompoundTag()));
    }

    public void load(CompoundTag tag) {
        this.progress = tag.m_128451_("progress");
        this.speed = tag.m_128451_("speed");
        this.inputSide = tag.m_128451_("input_dir");
        this.outputSide = tag.m_128451_("output_dir");
        this.itemStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("item_stack"));
    }

    public void writeDesc(MCDataOutput output) {
        output.writeByte(this.progress);
        output.writeByte(this.speed);
        output.writeByte(this.inputSide);
        output.writeByte(this.outputSide);
        output.writeItemStack(this.itemStack);
    }

    public void readDesc(MCDataInput input) {
        this.progress = input.readByte();
        this.speed = input.readByte();
        this.inputSide = input.readByte();
        this.outputSide = input.readByte();
        this.itemStack = input.readItemStack();
    }
}

