/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.part.MicroblockPart;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.api.part.IconHitEffectsPart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import codechicken.multipart.api.part.PartialOcclusionPart;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.Collections;
import mrtjp.projectred.api.Frame;
import mrtjp.projectred.expansion.block.FrameBlock;
import mrtjp.projectred.expansion.client.FrameModelRenderer;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.init.ExpansionParts;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FramePart
extends BaseMultipart
implements NormalOcclusionPart,
IconHitEffectsPart,
Frame {
    public static final Cuboid6[] oBounds = new Cuboid6[6];
    public static final VoxelShape[] oShapes = new VoxelShape[6];
    private static int sideOccludeTest = -1;
    private byte occludedSidesMask = 0;

    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128344_("omask", this.occludedSidesMask);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.occludedSidesMask = tag.m_128445_("omask");
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.occludedSidesMask);
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.occludedSidesMask = packet.readByte();
    }

    public boolean canGrab(Level w, BlockPos pos, Direction side) {
        return !this.isSideCovered(side.ordinal());
    }

    public boolean canBeGrabbed(Level w, BlockPos pos, Direction side) {
        return !this.isSideCovered(side.ordinal());
    }

    private boolean isSideCovered(int side) {
        MicroblockPart mb;
        MultiPart multiPart = this.tile().getSlottedPart(side);
        return multiPart instanceof MicroblockPart && (mb = (MicroblockPart)multiPart).getSize() == 1;
    }

    public void onAdded() {
        if (!this.level().f_46443_) {
            this.calcAndSendOccludedSidesMask();
        }
    }

    public void onNeighborBlockChanged(BlockPos neighbor) {
        if (!this.level().f_46443_) {
            this.calcAndSendOccludedSidesMask();
        }
    }

    public void onPartChanged(@Nullable MultiPart part) {
        if (!this.level().f_46443_) {
            this.calcAndSendOccludedSidesMask();
        }
    }

    public void onMoved() {
        super.onMoved();
        if (!this.level().f_46443_) {
            this.calcAndSendOccludedSidesMask();
        }
    }

    public MultipartType<?> getType() {
        return (MultipartType)ExpansionParts.FRAME_PART.get();
    }

    public float getStrength(Player player, PartRayTraceResult hit) {
        return ((Block)ExpansionBlocks.FRAME_BLOCK.get()).m_49966_().m_60625_(player, (BlockGetter)player.m_9236_(), new BlockPos(0, -1, 0));
    }

    @Nullable
    public SoundType getPlacementSound(UseOnContext context) {
        return ((Block)ExpansionBlocks.FRAME_BLOCK.get()).m_49966_().m_60827_();
    }

    public ItemStack getCloneStack(PartRayTraceResult hit) {
        return new ItemStack((ItemLike)ExpansionBlocks.FRAME_BLOCK.get());
    }

    public Iterable<ItemStack> getDrops() {
        return Collections.singleton(new ItemStack((ItemLike)ExpansionBlocks.FRAME_BLOCK.get()));
    }

    public VoxelShape getShape(CollisionContext context) {
        return FrameBlock.getOrGenerateShape(this.getOccludedSideMask());
    }

    public VoxelShape getCollisionShape(CollisionContext context) {
        return Shapes.m_83144_();
    }

    public VoxelShape getBlockSupportShape() {
        return Shapes.m_83040_();
    }

    public VoxelShape getOcclusionShape() {
        return sideOccludeTest != -1 ? oShapes[sideOccludeTest] : Shapes.m_83040_();
    }

    public boolean occlusionTest(MultiPart nPart) {
        NormalOcclusionPart p;
        if (nPart instanceof FramePart) {
            return false;
        }
        if (sideOccludeTest == -1) {
            return super.occlusionTest(nPart);
        }
        VoxelShape shape = nPart.getCollisionShape(CollisionContext.m_82749_());
        if (nPart instanceof NormalOcclusionPart) {
            p = (NormalOcclusionPart)nPart;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)p.getOcclusionShape());
        }
        if (nPart instanceof PartialOcclusionPart) {
            p = (PartialOcclusionPart)nPart;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)p.getPartialOcclusionShape());
        }
        return !Shapes.m_83157_((VoxelShape)shape, (VoxelShape)this.getOcclusionShape(), (BooleanOp)BooleanOp.f_82689_);
    }

    public int getOccludedSideMask() {
        return this.occludedSidesMask & 0xFF;
    }

    private void calcAndSendOccludedSidesMask() {
        byte oldMask = this.occludedSidesMask;
        this.occludedSidesMask = 0;
        for (int s = 0; s < 6; ++s) {
            sideOccludeTest = s;
            if (this.tile().canReplacePart((MultiPart)this, (MultiPart)this)) continue;
            this.occludedSidesMask = (byte)(this.occludedSidesMask | 1 << s);
        }
        sideOccludeTest = -1;
        if (oldMask != this.occludedSidesMask) {
            this.sendUpdate(this::writeDesc);
        }
    }

    public Cuboid6 getBounds() {
        return Cuboid6.full;
    }

    public TextureAtlasSprite getBreakingIcon(PartRayTraceResult hit) {
        return FrameModelRenderer.getFrameIcon();
    }

    public TextureAtlasSprite getBrokenIcon(int side) {
        return FrameModelRenderer.getFrameIcon();
    }

    static {
        for (int s = 0; s < 6; ++s) {
            Cuboid6 box;
            Transformation transform = Rotation.sideRotations[s].at(Vector3.CENTER);
            double d = 0.25;
            FramePart.oBounds[s] = box = new Cuboid6(d, 0.0, d, 1.0 - d, d, 1.0 - d).apply(transform);
            FramePart.oShapes[s] = VoxelShapeCache.getShape((Cuboid6)box);
        }
    }
}

