/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Function;
import mrtjp.projectred.expansion.ExpansionNetwork;
import mrtjp.projectred.expansion.graphs.ClientSideLinkCache;
import mrtjp.projectred.expansion.graphs.GraphContainer;
import mrtjp.projectred.expansion.part.PneumaticTubePart;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;

public class GraphDebugManager {
    private static final HashMap<ResourceKey<Level>, GraphDebugManager> CLIENT_INSTANCE = new HashMap();
    private static boolean enableRendering = false;
    private final ResourceKey<Level> dimension;
    private final HashSet<GraphContainer> containers = new HashSet();

    public GraphDebugManager(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public static GraphDebugManager getInstance(Level level) {
        return CLIENT_INSTANCE.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), GraphDebugManager::new);
    }

    private PacketCustom createPacket(int key) {
        return new PacketCustom(ExpansionNetwork.NET_CHANNEL, 2).writeByte(key);
    }

    public void read(MCDataInput input, Level level) {
        short key = input.readUByte();
        switch (key) {
            default: 
        }
        throw new RuntimeException("Unknown key: " + key);
    }

    public void onWorldJoin(GraphContainer container) {
        this.containers.add(container);
    }

    public void onWorldSeparate(GraphContainer container) {
        this.containers.remove(container);
    }

    public static void registerClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"project_red").then(Commands.m_82127_((String)"tube_graph_debug").then(Commands.m_82129_((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            enableRendering = BoolArgumentType.getBool((CommandContext)ctx, (String)"enable");
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Tube graph debugging " + (enableRendering ? "enabled" : "disabled"))), false);
            return 0;
        }))));
    }

    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            GraphDebugManager.getInstance((Level)level).containers.clear();
        }
    }

    public static void onLevelTick(TickEvent.LevelTickEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (!enableRendering) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        GraphDebugManager renderer = GraphDebugManager.getInstance((Level)level);
        HashMap<BlockPos, ClientSideLinkCache> links = new HashMap<BlockPos, ClientSideLinkCache>();
        for (GraphContainer container : renderer.containers) {
            if (!(container instanceof PneumaticTubePart)) continue;
            PneumaticTubePart ptp = (PneumaticTubePart)container;
            if (!ptp.linkCache.isActive()) continue;
            links.put(ptp.pos(), ptp.linkCache);
        }
        if (links.isEmpty()) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Vec3 cam = event.getCamera().m_90583_();
        PoseStack stack = event.getPoseStack();
        stack.m_85836_();
        stack.m_85837_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        GraphDebugManager.renderLinks(stack, buffers, links);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderLinks(PoseStack stack, MultiBufferSource.BufferSource buffers, Map<BlockPos, ClientSideLinkCache> links) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind(GraphDebugManagerClientRenderTypes.DEBUG_LINES_RENDER_TYPE.apply(2.0), (MultiBufferSource)buffers, stack);
        ccrs.baseColour = EnumColour.ORANGE.rgba();
        for (Map.Entry<BlockPos, ClientSideLinkCache> entry : links.entrySet()) {
            RenderUtils.bufferCuboidOutline((VertexConsumer)ccrs.getConsumer(), (Cuboid6)Cuboid6.full.copy().expand(-0.125).add(entry.getKey()), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        ccrs.bind(GraphDebugManagerClientRenderTypes.DEBUG_LINES_RENDER_TYPE.apply(1.5), (MultiBufferSource)buffers, stack);
        ccrs.baseColour = EnumColour.LIGHT_BLUE.rgba();
        for (Map.Entry<BlockPos, ClientSideLinkCache> entry : links.entrySet()) {
            for (ClientSideLinkCache.ClientLink link : entry.getValue().links) {
                BlockPos segStart;
                LinkedList<Vector3> segmentPoints = link.getPointListFor(segStart = entry.getKey());
                if (segmentPoints.isEmpty()) continue;
                Iterator pointsIt = segmentPoints.iterator();
                Vector3 p1 = (Vector3)pointsIt.next();
                while (pointsIt.hasNext()) {
                    Vector3 p2 = (Vector3)pointsIt.next();
                    GraphDebugManager.bufferLinePair(ccrs.getConsumer(), p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, 1.0f, 1.0f, 1.0f, 1.0f);
                    p1 = p2;
                }
                double s = 4.0;
                RenderUtils.bufferCuboidOutline((VertexConsumer)ccrs.getConsumer(), (Cuboid6)new Cuboid6(-s / 16.0, -s / 16.0, -s / 16.0, s / 16.0, s / 16.0, s / 16.0).add(segmentPoints.getFirst()), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                s = 5.0;
                RenderUtils.bufferCuboidOutline((VertexConsumer)ccrs.getConsumer(), (Cuboid6)new Cuboid6(-s / 16.0, -s / 16.0, -s / 16.0, s / 16.0, s / 16.0, s / 16.0).add(segmentPoints.getLast()), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        ccrs.bind(GraphDebugManagerClientRenderTypes.DEBUG_CUBE_RENDER_TYPE, (MultiBufferSource)buffers, stack);
        ccrs.baseColour = EnumColour.LIGHT_BLUE.rgba(128);
        double b = 0.03125;
        Cuboid6 box = new Cuboid6(-b, -b, -b, b, b, b);
        for (Map.Entry<BlockPos, ClientSideLinkCache> entry : links.entrySet()) {
            for (ClientSideLinkCache.ClientLink link : entry.getValue().links) {
                LinkedList<Vector3> points = link.getPointListFor(entry.getKey());
                for (Vector3 p : points) {
                    ccrs.setPipeline(new IVertexOperation[]{new Translation(p)});
                    BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)0);
                }
            }
        }
        buffers.m_109911_();
        stack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void bufferLinePair(VertexConsumer builder, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        Vector3 v1 = new Vector3(x1, y1, z1).subtract(x2, y2, z2);
        double d = v1.mag();
        v1.divide(d);
        builder.m_5483_(x1, y1, z1).m_85950_(r, g, b, a).m_5601_((float)v1.x, (float)v1.y, (float)v1.z).m_5752_();
        builder.m_5483_(x2, y2, z2).m_85950_(r, g, b, a).m_5601_((float)v1.x, (float)v1.y, (float)v1.z).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GraphDebugManagerClientRenderTypes {
        @OnlyIn(value=Dist.CLIENT)
        private static RenderType DEBUG_CUBE_RENDER_TYPE = RenderType.m_173215_((String)"projectred_expansion:graph_debug_cube", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173104_).m_173290_(RenderStateShard.f_110147_).m_110685_(RenderStateShard.f_110139_).m_110663_(RenderStateShard.f_110113_).m_110661_(RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110153_).m_110677_(RenderStateShard.f_110155_).m_110669_(RenderStateShard.f_110117_).m_110675_(RenderStateShard.f_110126_).m_110683_(RenderStateShard.f_110148_).m_110687_(RenderStateShard.f_110114_).m_110673_(RenderStateShard.f_110130_).m_110691_(true));
        @OnlyIn(value=Dist.CLIENT)
        public static Function<Double, RenderType> DEBUG_LINES_RENDER_TYPE = Util.m_143827_(a -> RenderType.m_173215_((String)"projectred_expansion:graph_debug_lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173095_).m_173290_(RenderStateShard.f_110147_).m_110685_(RenderStateShard.f_110139_).m_110663_(RenderStateShard.f_110113_).m_110661_(RenderStateShard.f_110110_).m_110671_(RenderStateShard.f_110153_).m_110677_(RenderStateShard.f_110155_).m_110669_(RenderStateShard.f_110119_).m_110675_(RenderStateShard.f_110126_).m_110683_(RenderStateShard.f_110148_).m_110687_(RenderStateShard.f_110114_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(a))).m_110691_(false)));

        private GraphDebugManagerClientRenderTypes() {
        }
    }
}

