/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import javax.annotation.Nullable;
import mrtjp.projectred.core.tile.IConnectableBlockEntity;
import mrtjp.projectred.core.tile.IPacketReceiverBlockEntity;
import mrtjp.projectred.core.tile.ProjectRedBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BaseConnectableBlockEntity
extends ProjectRedBlockEntity
implements IConnectableBlockEntity,
IPacketReceiverBlockEntity {
    public static final int PACKET_CONN_MAP = 2;
    private long connMap = 0L;

    public BaseConnectableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public long getConnMap() {
        return this.connMap;
    }

    @Override
    public void setConnMap(long connMap) {
        this.connMap = connMap;
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        tag.m_128356_("connMap", this.connMap);
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        this.connMap = tag.m_128454_("connMap");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        out.writeLong(this.connMap);
    }

    @Override
    public void readDesc(MCDataInput in) {
        this.connMap = in.readLong();
    }

    @Override
    public void receiveUpdateFromServer(int key, MCDataInput input) {
        if (key == 2) {
            this.connMap = input.readLong();
        }
    }

    @Override
    public void receiveUpdateFromClient(int key, MCDataInput input, ServerPlayer player) {
    }

    protected boolean clientNeedsMask() {
        return false;
    }

    protected void sendConnUpdate() {
        if (this.clientNeedsMask()) {
            this.sendUpdateToPlayersWatchingChunk(2, out -> out.writeLong(this.connMap));
        }
    }

    @Override
    public void onMaskChanged() {
        this.sendConnUpdate();
    }

    @Override
    public void onNeighborBlockChanged(BlockPos neighborPos) {
        super.onNeighborBlockChanged(neighborPos);
        if (!this.getBlockLevel().f_46443_) {
            this.updateExternals();
        }
    }

    @Override
    public void onBlockPlaced(@Nullable LivingEntity player, ItemStack item) {
        super.onBlockPlaced(player, item);
        if (!this.getBlockLevel().f_46443_) {
            this.updateExternals();
        }
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        if (!this.getBlockLevel().f_46443_) {
            this.notifyConnectedExternals();
        }
    }
}

