/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawersextra.data;

import com.jaquadro.minecraft.storagedrawersextra.block.VariantRegistry;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        for (VariantRegistry variant : VariantRegistry.values()) {
            if (variant.getMod() == null || !variant.getMod().isLoaded()) continue;
            this.makeTrim(variant, consumer);
            this.makeDrawer1(variant, true, consumer);
            this.makeDrawer2(variant, true, consumer);
            this.makeDrawer4(variant, true, consumer);
            this.makeDrawer1(variant, false, consumer);
            this.makeDrawer2(variant, false, consumer);
            this.makeDrawer4(variant, false, consumer);
        }
    }

    private void makeTrim(VariantRegistry variant, Consumer<FinishedRecipe> consumer) {
        if (variant.getPlankResource() == null) {
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(variant.getPlankResource());
        if (plank == null) {
            return;
        }
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)variant.getData().blockTrim.get()), (int)4).m_126130_("x/x").m_126130_("/x/").m_126130_("x/x").m_126127_(Character.valueOf('x'), (ItemLike)plank).m_206416_(Character.valueOf('/'), Tags.Items.RODS_WOODEN).m_126145_("storagedrawersextra").m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)plank)).m_176498_(consumer);
    }

    private void makeDrawer1(VariantRegistry variant, boolean half, Consumer<FinishedRecipe> consumer) {
        ResourceLocation woodResource;
        ResourceLocation resourceLocation = woodResource = half ? variant.getSlabResource() : variant.getPlankResource();
        if (woodResource == null) {
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(woodResource);
        if (plank == null) {
            return;
        }
        Block block = half ? (Block)variant.getData().blockHalf1.get() : (Block)variant.getData().blockFull1.get();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)block, (int)1).m_126130_("///").m_126130_(" x ").m_126130_("///").m_206416_(Character.valueOf('x'), Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('/'), (ItemLike)plank).m_126145_("storagedrawersextra").m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.m_206406_((TagKey)Tags.Items.CHESTS_WOODEN)).m_176498_(consumer);
    }

    private void makeDrawer2(VariantRegistry variant, boolean half, Consumer<FinishedRecipe> consumer) {
        ResourceLocation woodResource;
        ResourceLocation resourceLocation = woodResource = half ? variant.getSlabResource() : variant.getPlankResource();
        if (woodResource == null) {
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(woodResource);
        if (plank == null) {
            return;
        }
        Block block = half ? (Block)variant.getData().blockHalf2.get() : (Block)variant.getData().blockFull2.get();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)block, (int)2).m_126130_("/x/").m_126130_("///").m_126130_("/x/").m_206416_(Character.valueOf('x'), Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('/'), (ItemLike)plank).m_126145_("storagedrawersextra").m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.m_206406_((TagKey)Tags.Items.CHESTS_WOODEN)).m_176498_(consumer);
    }

    private void makeDrawer4(VariantRegistry variant, boolean half, Consumer<FinishedRecipe> consumer) {
        ResourceLocation woodResource;
        ResourceLocation resourceLocation = woodResource = half ? variant.getSlabResource() : variant.getPlankResource();
        if (woodResource == null) {
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(woodResource);
        if (plank == null) {
            return;
        }
        Block block = half ? (Block)variant.getData().blockHalf4.get() : (Block)variant.getData().blockFull4.get();
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)block, (int)4).m_126130_("x/x").m_126130_("///").m_126130_("x/x").m_206416_(Character.valueOf('x'), Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('/'), (ItemLike)plank).m_126145_("storagedrawersextra").m_126132_("has_item", (CriterionTriggerInstance)ModRecipeProvider.m_206406_((TagKey)Tags.Items.CHESTS_WOODEN)).m_176498_(consumer);
    }
}

