/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawersextra.data;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawersextra.block.VariantRegistry;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "storagedrawersextra", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (VariantRegistry variant : VariantRegistry.values()) {
            this.registerVariant(variant);
        }
    }

    void registerVariant(VariantRegistry variant) {
        BlockModelBuilder blockTrim = (BlockModelBuilder)this.models().cubeAll(variant.getTrimModelName(), this.modLoc(variant.getTextureName("side")));
        this.simpleBlock((Block)variant.getData().blockTrim.get(), (ModelFile)blockTrim);
        this.standardDrawer(variant, (BlockStandardDrawers)variant.getData().blockFull1.get(), new ResourceLocation("storagedrawersextra", variant.getTextureName("side")), new ResourceLocation("storagedrawersextra", variant.getTextureName("front_1")), new ResourceLocation("storagedrawersextra", variant.getTextureName("trim")), 1, false);
        this.standardDrawer(variant, (BlockStandardDrawers)variant.getData().blockFull2.get(), new ResourceLocation("storagedrawersextra", variant.getTextureName("side")), new ResourceLocation("storagedrawersextra", variant.getTextureName("front_2")), new ResourceLocation("storagedrawersextra", variant.getTextureName("trim")), 2, false);
        this.standardDrawer(variant, (BlockStandardDrawers)variant.getData().blockFull4.get(), new ResourceLocation("storagedrawersextra", variant.getTextureName("side")), new ResourceLocation("storagedrawersextra", variant.getTextureName("front_4")), new ResourceLocation("storagedrawersextra", variant.getTextureName("trim")), 4, false);
        this.standardDrawer(variant, (BlockStandardDrawers)variant.getData().blockHalf1.get(), new ResourceLocation("storagedrawersextra", variant.getTextureName("side")), new ResourceLocation("storagedrawersextra", variant.getTextureName("front_1")), new ResourceLocation("storagedrawersextra", variant.getTextureName("side_h")), new ResourceLocation("storagedrawersextra", variant.getTextureName("side")), new ResourceLocation("storagedrawersextra", variant.getTextureName("trim")), 1, true);
        this.standardDrawer(variant, (BlockStandardDrawers)variant.getData().blockHalf2.get(), new ResourceLocation("storagedrawersextra", variant.getTextureName("side")), new ResourceLocation("storagedrawersextra", variant.getTextureName("front_2")), new ResourceLocation("storagedrawersextra", variant.getTextureName("side_h")), new ResourceLocation("storagedrawersextra", variant.getTextureName("side")), new ResourceLocation("storagedrawersextra", variant.getTextureName("trim")), 2, true);
        this.standardDrawer(variant, (BlockStandardDrawers)variant.getData().blockHalf4.get(), new ResourceLocation("storagedrawersextra", variant.getTextureName("side")), new ResourceLocation("storagedrawersextra", variant.getTextureName("front_4")), new ResourceLocation("storagedrawersextra", variant.getTextureName("side_h")), new ResourceLocation("storagedrawersextra", variant.getTextureName("side")), new ResourceLocation("storagedrawersextra", variant.getTextureName("trim")), 4, true);
    }

    void standardDrawer(VariantRegistry variant, BlockStandardDrawers block, ResourceLocation side, ResourceLocation front, ResourceLocation trim, int size, boolean half) {
        this.standardDrawer(variant, block, side, front, side, side, trim, size, half);
    }

    void standardDrawer(VariantRegistry variant, BlockStandardDrawers block, ResourceLocation side, ResourceLocation front, ResourceLocation top, ResourceLocation back, ResourceLocation trim, int size, boolean half) {
        String parentType = half ? "half" : "full";
        ResourceLocation parent = new ResourceLocation("storagedrawers", "block/" + parentType + "_drawers_orientable");
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(variant.getDrawerModelName(size, half), parent)).texture("particle", front)).texture("east", side)).texture("west", side)).texture("north", front)).texture("up", top)).texture("down", top)).texture("south", back)).texture("trim", trim);
        this.drawerState(block, (ModelFile)model);
    }

    void drawerState(BlockStandardDrawers block, ModelFile model) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        builder.partialState().with((Property)BlockDrawers.f_54117_, (Comparable)Direction.NORTH).addModels(new ConfiguredModel[]{new ConfiguredModel(model)});
        builder.partialState().with((Property)BlockDrawers.f_54117_, (Comparable)Direction.EAST).addModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, 90, false)});
        builder.partialState().with((Property)BlockDrawers.f_54117_, (Comparable)Direction.SOUTH).addModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, 180, false)});
        builder.partialState().with((Property)BlockDrawers.f_54117_, (Comparable)Direction.WEST).addModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, 270, false)});
    }
}

