/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawersextra.block;

import com.jaquadro.minecraft.storagedrawers.core.ModBlockVariants;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumMod;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;

public enum VariantRegistry {
    BIOMESOPLENTY_FIR("biomesoplenty", "fir", "fir_planks", "fir_slab"),
    BIOMESOPLENTY_REDWOOD("biomesoplenty", "redwood", "redwood_planks", "redwood_slab"),
    BIOMESOPLENTY_MAHOGANY("biomesoplenty", "mahogany", "mahogany_planks", "mahogany_slab"),
    BIOMESOPLENTY_JACARANDA("biomesoplenty", "jacaranda", "jacaranda_planks", "jacaranda_slab"),
    BIOMESOPLENTY_PALM("biomesoplenty", "palm", "palm_planks", "palm_slab"),
    BIOMESOPLENTY_WILLOW("biomesoplenty", "willow", "willow_planks", "willow_slab"),
    BIOMESOPLENTY_DEAD("biomesoplenty", "dead", "dead_planks", "dead_slab"),
    BIOMESOPLENTY_MAGIC("biomesoplenty", "magic", "magic_planks", "magic_slab"),
    BIOMESOPLENTY_UMBRAN("biomesoplenty", "umbran", "umbran_planks", "umbran_slab"),
    BIOMESOPLENTY_HELLBARK("biomesoplenty", "hellbark", "hellbark_planks", "hellbark_slab"),
    BIOMESWEVEGONE_ASPEN("biomeswevegone", "aspen", "aspen_planks", "aspen_slab"),
    BIOMESWEVEGONE_BAOBAB("biomeswevegone", "baobab", "baobab_planks", "baobab_slab"),
    BIOMESWEVEGONE_BLUEENCHANTED("biomeswevegone", "blue_enchanted", "blue_enchanted_planks", "blue_enchanted_slab"),
    BIOMESWEVEGONE_CIKA("biomeswevegone", "cika", "cika_planks", "cika_slab"),
    BIOMESWEVEGONE_CYPRESS("biomeswevegone", "cypress", "cypress_planks", "cypress_slab"),
    BIOMESWEVEGONE_EBONY("biomeswevegone", "ebony", "ebony_planks", "ebony_slab"),
    BIOMESWEVEGONE_FIR("biomeswevegone", "fir", "fir_planks", "fir_slab"),
    BIOMESWEVEGONE_FLORUS("biomeswevegone", "florus", "florus_planks", "florus_slab"),
    BIOMESWEVEGONE_GREENENCHANTED("biomeswevegone", "green_enchanted", "green_enchanted_planks", "green_enchanted_slab"),
    BIOMESWEVEGONE_HOLLY("biomeswevegone", "holly", "holly_planks", "holly_slab"),
    BIOMESWEVEGONE_IRONWOOD("biomeswevegone", "ironwood", "ironwood_planks", "ironwood_slab"),
    BIOMESWEVEGONE_JACARANDA("biomeswevegone", "jacaranda", "jacaranda_planks", "jacaranda_slab"),
    BIOMESWEVEGONE_MAHOGANY("biomeswevegone", "mahogany", "mahogany_planks", "mahogany_slab"),
    BIOMESWEVEGONE_MAPLE("biomeswevegone", "maple", "maple_planks", "maple_slab"),
    BIOMESWEVEGONE_PALM("biomeswevegone", "palm", "palm_planks", "palm_slab"),
    BIOMESWEVEGONE_PINE("biomeswevegone", "pine", "pine_planks", "pine_slab"),
    BIOMESWEVEGONE_RAINBOWEUCALYPTUS("biomeswevegone", "rainbow_eucalyptus", "rainbow_eucalyptus_planks", "rainbow_eucalyptus_slab"),
    BIOMESWEVEGONE_REDWOOD("biomeswevegone", "redwood", "redwood_planks", "redwood_slab"),
    BIOMESWEVEGONE_SAKURA("biomeswevegone", "sakura", "sakura_planks", "sakura_slab"),
    BIOMESWEVEGONE_SKYRIS("biomeswevegone", "skyris", "skyris_planks", "skyris_slab"),
    BIOMESWEVEGONE_WHITEMANGROVE("biomeswevegone", "white_mangrove", "white_mangrove_planks", "white_mangrove_slab"),
    BIOMESWEVEGONE_WILLOW("biomeswevegone", "willow", "willow_planks", "willow_slab"),
    BIOMESWEVEGONE_WITCHHAZEL("biomeswevegone", "witch_hazel", "witch_hazel_planks", "witch_hazel_slab"),
    BIOMESWEVEGONE_ZELKOVA("biomeswevegone", "zelkova", "zelkova_planks", "zelkova_slab"),
    IMMENG_TREATED("immersiveengineering", "immeng_treated", "treated_wood_horizontal", "slab_treated_wood_horizontal");

    private final String modid;
    private final String name;
    private final ResourceLocation plankResource;
    private final ResourceLocation slabResource;
    private final ModBlockVariants.VariantData data;

    private VariantRegistry(String modid, String name, String plankName, String slabName) {
        this.modid = modid;
        this.name = name;
        this.plankResource = plankName != null ? new ResourceLocation(modid, plankName) : null;
        this.slabResource = slabName != null ? new ResourceLocation(modid, slabName) : null;
        this.data = new ModBlockVariants.VariantData(new ResourceLocation("storagedrawersextra", modid + "_" + name));
    }

    public String getModid() {
        return this.modid;
    }

    public String getName() {
        return this.name;
    }

    public EnumMod getMod() {
        return EnumMod.byId(this.modid);
    }

    public ResourceLocation getPlankResource() {
        return this.plankResource;
    }

    public ResourceLocation getSlabResource() {
        return this.slabResource;
    }

    public ModBlockVariants.VariantData getData() {
        return this.data;
    }

    public String getTrimModelName() {
        return "block/" + this.modid + "_" + this.name + "_trim";
    }

    public String getTrimItemName() {
        return "item/" + this.modid + "_" + this.name + "_trim";
    }

    public String getDrawerModelName(int size, boolean half) {
        String type = half ? "half" : "full";
        return "block/" + this.modid + "_" + this.name + "_" + type + "_drawers_" + size;
    }

    public String getItemModelName(int size, boolean half) {
        String type = half ? "half" : "full";
        return "item/" + this.modid + "_" + this.name + "_" + type + "_drawers_" + size;
    }

    public String getTextureName(String textureVariant) {
        return "block/" + this.modid + "/drawers_" + this.name + "_" + textureVariant;
    }

    public void registerBlocks(DeferredRegister<Block> register) {
        ModBlockVariants.registerVariant(register, (ModBlockVariants.VariantData)this.data);
    }

    public void registerItems(DeferredRegister<Item> register) {
        ModBlockVariants.registerVariantItem(register, (ModBlockVariants.VariantData)this.data);
    }

    private static class MODID {
        public static final String BIOMESOPLENTY = "biomesoplenty";
        public static final String BIOMESWEVEGONE = "biomeswevegone";
        public static final String IMMERSIVEENGINEERING = "immersiveengineering";

        private MODID() {
        }
    }
}

