/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.drone;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModEntityTypes;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.items.ItemStackHandler;

public class AmadroneEntity
extends DroneEntity {
    private static ItemStack amadroneStack = ItemStack.f_41583_;
    private ResourceLocation handlingOffer;
    private int offerTimes;
    private ItemStack usedTablet = ItemStack.f_41583_;
    private String buyingPlayer;
    private AmadronAction amadronAction;

    public AmadroneEntity(EntityType<? extends DroneEntity> type, Level world) {
        super(type, world, null);
        this.m_6593_((Component)Component.m_237115_((String)"pneumaticcraft.drone.amadronDeliveryDrone"));
    }

    public static AmadroneEntity makeAmadrone(Level world, BlockPos pos) {
        AmadroneEntity drone = new AmadroneEntity((EntityType<? extends DroneEntity>)((EntityType)ModEntityTypes.AMADRONE.get()), world);
        drone.readFromItemStack(AmadroneEntity.getAmadroneStack());
        List offsets = (List)ConfigHelper.common().amadron.amadroneSpawnLocation.get();
        if (offsets.size() != 3) {
            Log.error("invalid offsets for amadron_spawn_location; expecting list of 3 integers! Defaulting to (30, 30, 0)", new Object[0]);
            offsets = ImmutableList.of((Object)30, (Object)30, (Object)0);
        }
        int xOff = (Integer)offsets.get(0);
        int yOff = (Integer)offsets.get(1);
        int zOff = (Integer)offsets.get(2);
        int startY = (Boolean)ConfigHelper.common().amadron.amadroneSpawnLocationRelativeToGroundLevel.get() != false ? world.m_5452_(Heightmap.Types.WORLD_SURFACE, pos.m_7918_(xOff, 0, zOff)).m_123342_() + yOff : pos.m_123342_() + yOff;
        drone.m_6034_(pos.m_123341_() + xOff, startY, pos.m_123343_() + zOff);
        return drone;
    }

    private static ItemStack getAmadroneStack() {
        if (amadroneStack.m_41619_()) {
            amadroneStack = new ItemStack((ItemLike)ModItems.DRONE.get());
            ItemStackHandler upgradeInv = new ItemStackHandler(9);
            upgradeInv.setStackInSlot(0, ModUpgrades.SPEED.get().getItemStack(10));
            upgradeInv.setStackInSlot(1, ModUpgrades.INVENTORY.get().getItemStack(35));
            upgradeInv.setStackInSlot(2, ModUpgrades.ITEM_LIFE.get().getItemStack(10));
            upgradeInv.setStackInSlot(3, ModUpgrades.SECURITY.get().getItemStack());
            UpgradableItemUtils.setUpgrades(amadroneStack, upgradeInv);
            ((IAirHandlerItem)amadroneStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new)).addAir(100000);
        }
        return amadroneStack;
    }

    public void setHandlingOffer(ResourceLocation offerId, int times, @Nonnull ItemStack usedTablet, String buyingPlayer, AmadronAction amadronAction) {
        this.handlingOffer = offerId;
        this.offerTimes = times;
        this.usedTablet = usedTablet.m_41777_();
        this.buyingPlayer = buyingPlayer;
        this.amadronAction = amadronAction;
    }

    public ResourceLocation getHandlingOffer() {
        return this.handlingOffer;
    }

    public AmadronAction getAmadronAction() {
        return this.amadronAction;
    }

    public int getOfferTimes() {
        return this.offerTimes;
    }

    public ItemStack getUsedTablet() {
        return this.usedTablet;
    }

    public String getBuyingPlayer() {
        return this.buyingPlayer;
    }

    @Override
    public boolean shouldDropAsItem() {
        return false;
    }

    public boolean m_6149_() {
        return false;
    }

    @Override
    protected void m_5907_() {
    }

    @Override
    public int getUpgrades(PNCUpgrade upgrade) {
        if (ModUpgrades.SECURITY.get() == upgrade) {
            return 1;
        }
        if (ModUpgrades.ITEM_LIFE.get() == upgrade || ModUpgrades.SPEED.get() == upgrade) {
            return 10;
        }
        if (ModUpgrades.INVENTORY.get() == upgrade) {
            return 35;
        }
        return 0;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.handlingOffer != null) {
            CompoundTag subTag = new CompoundTag();
            subTag.m_128359_("offerId", this.handlingOffer.toString());
            subTag.m_128405_("offerTimes", this.offerTimes);
            subTag.m_128359_("buyingPlayer", this.buyingPlayer);
            if (!this.usedTablet.m_41619_()) {
                subTag.m_128365_("usedTablet", (Tag)this.usedTablet.m_41739_(new CompoundTag()));
            }
            subTag.m_128359_("amadronAction", this.amadronAction.toString());
            tag.m_128365_("amadron", (Tag)subTag);
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("amadron")) {
            CompoundTag subTag = tag.m_128469_("amadron");
            this.handlingOffer = new ResourceLocation(subTag.m_128461_("offerId"));
            this.usedTablet = ItemStack.m_41712_((CompoundTag)subTag.m_128469_("usedTablet"));
            this.offerTimes = subTag.m_128451_("offerTimes");
            this.buyingPlayer = subTag.m_128461_("buyingPlayer");
            this.amadronAction = AmadronAction.valueOf(subTag.m_128461_("amadronAction"));
        }
    }

    @Override
    public boolean isTeleportRangeLimited() {
        return false;
    }

    @Override
    public void overload(String msgKey, Object ... params) {
        NetworkHandler.sendToAllTracking((Object)new PacketSpawnParticle((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() - 0.5, this.m_20186_() - 0.5, this.m_20189_() - 0.5, 0.0, 0.1, 0.0, 10, 1.0, 1.0, 1.0), (Entity)this);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.m_146870_();
    }

    public static enum AmadronAction {
        TAKING_PAYMENT,
        RESTOCKING;

    }
}

