/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.api.UpgradeablePreservation;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.menu.FruitBasketMenu;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FruitBasketBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider,
IMutableNameable,
BalmContainerProvider,
UpgradeablePreservation {
    private final DefaultContainer container = new DefaultContainer(27){

        public void m_6596_() {
            FruitBasketBlockEntity.this.m_6596_();
            FruitBasketBlockEntity.this.sync();
        }
    };
    private final DefaultKitchenItemProvider itemProvider = new DefaultKitchenItemProvider((Container)this.container){

        @Override
        public boolean hasPreservationUpgrade() {
            return FruitBasketBlockEntity.this.hasPreservationUpgrade();
        }
    };
    private boolean hasPreservationUpgrade;
    private Component customName;
    private boolean isDirty;

    public FruitBasketBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.fruitBasket.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.hasPreservationUpgrade = tag.m_128471_("HasPreservationUpgrade");
        this.container.deserialize(tag.m_128469_("ItemHandler"));
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("ItemHandler", (Tag)this.container.serialize());
        tag.m_128379_("HasPreservationUpgrade", this.hasPreservationUpgrade);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.m_183515_(tag);
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.m_6596_();
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new FruitBasketMenu(i, playerInventory, this);
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"container.cookingforblockheads.fruit_basket");
    }

    public Container getContainer() {
        return this.container;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FruitBasketBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public void m_6596_() {
        this.isDirty = true;
        super.m_6596_();
    }

    @Override
    public boolean hasPreservationUpgrade() {
        return this.hasPreservationUpgrade;
    }

    @Override
    public void setHasPreservationUpgrade(boolean hasPreservationUpgrade) {
        this.hasPreservationUpgrade = hasPreservationUpgrade;
        this.m_6596_();
    }
}

